/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzjq;

public final class Device
implements SafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int zzzH;
    private final String zzado;
    private final String zzadp;
    private final String zzacK;
    private final String zzadq;
    private final int zzMG;
    private final int zzadr;
    public static final Parcelable.Creator<Device> CREATOR = new zzh();

    public static Device getLocalDevice(Context context) {
        int n = zzin.zzac(context);
        String string = Device.zzY(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    private static String zzY(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public Device(String manufacturer, String model, String uid, int type) {
        this(manufacturer, model, "", uid, type, 0);
    }

    public Device(String manufacturer, String model, String version, String uid, int type, int platformType) {
        this(1, manufacturer, model, "", uid, type, platformType);
    }

    Device(int versionCode, String manufacturer, String model, String version, String uid, int type, int platformType) {
        this.zzzH = versionCode;
        this.zzado = (String)zzv.zzr((Object)manufacturer);
        this.zzadp = (String)zzv.zzr((Object)model);
        this.zzacK = "";
        this.zzadq = (String)zzv.zzr((Object)uid);
        this.zzMG = type;
        this.zzadr = platformType;
    }

    public String getManufacturer() {
        return this.zzado;
    }

    public String getModel() {
        return this.zzadp;
    }

    public String getVersion() {
        return this.zzacK;
    }

    public String getUid() {
        return this.zzadq;
    }

    public int getType() {
        return this.zzMG;
    }

    public int zzoP() {
        return this.zzadr;
    }

    private boolean zzoQ() {
        return this.zzoP() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzado, this.zzadp, this.zzadq);
    }

    public String zzoR() {
        return this.zzoQ() ? this.zzadq : zzjq.zzcr(this.zzadq);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.zzacK, this.zzMG, this.zzadr);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Device && this.zza((Device)that);
    }

    private boolean zza(Device device) {
        return zzu.equal((Object)this.zzado, (Object)device.zzado) && zzu.equal((Object)this.zzadp, (Object)device.zzadp) && zzu.equal((Object)this.zzacK, (Object)device.zzacK) && zzu.equal((Object)this.zzadq, (Object)device.zzadq) && this.zzMG == device.zzMG && this.zzadr == device.zzadr;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzado, this.zzadp, this.zzacK, this.zzadq, this.zzMG});
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzh.zza(this, parcel, flags);
    }
}

