/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzd;
import com.google.android.gms.internal.zzim;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int zzzH;
    private final DataSource zzacD;
    private long zzacT;
    private long zzacU;
    private final Value[] zzacV;
    private DataSource zzacW;
    private long zzacX;
    private long zzacY;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzd();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.zzzH = versionCode;
        this.zzacD = dataSource;
        this.zzacW = originalDataSource;
        this.zzacT = timestampNanos;
        this.zzacU = startTimeNanos;
        this.zzacV = values;
        this.zzacX = rawTimestamp;
        this.zzacY = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(DataPoint.zza(dataSources, rawDataPoint.zzadC), DataPoint.zza(dataSources, rawDataPoint.zzadD), rawDataPoint);
    }

    public DataPoint(DataSource dataSource, DataSource originalDataSource, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzacT, 0L), DataPoint.zza(rawDataPoint.zzacU, 0L), rawDataPoint.zzacV, originalDataSource, DataPoint.zza(rawDataPoint.zzacX, 0L), DataPoint.zza(rawDataPoint.zzacY, 0L));
    }

    private static DataSource zza(List<DataSource> list, int n) {
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.zzzH = 4;
        this.zzacD = (DataSource)zzv.zzb((Object)dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.zzacV = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzacV[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzc.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit timeUnit) {
        this.zzacT = timeUnit.toNanos(timestamp);
        if (this.zzoE() && zzim.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzacT = zzim.zza(this.zzacT, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean zzoE() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
        this.zzacU = timeUnit.toNanos(startTime);
        this.zzacT = timeUnit.toNanos(endTime);
        return this;
    }

    public Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzacV[n];
    }

    public Value[] zzoF() {
        return this.zzacV;
    }

    public DataPoint setFloatValues(float ... values) {
        this.zzdz(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzacV[i].setFloat(values[i]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.zzdz(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzacV[i].setInt(values[i]);
        }
        return this;
    }

    private void zzdz(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzv.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public DataType getDataType() {
        return this.zzacD.getDataType();
    }

    public DataSource getDataSource() {
        return this.zzacD;
    }

    public DataSource getOriginalDataSource() {
        return this.zzacW;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzacT, TimeUnit.NANOSECONDS);
    }

    public long zzoG() {
        return this.zzacX;
    }

    public long zzoH() {
        return this.zzacY;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzacU, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzacT, TimeUnit.NANOSECONDS);
    }

    public void zzoI() {
        DataSource dataSource = this.getDataSource();
        zzv.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzv.zzb((this.zzacT > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzv.zzb((this.zzacU <= this.zzacT ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DataPoint && this.zza((DataPoint)o);
    }

    private boolean zza(DataPoint dataPoint) {
        return zzu.equal((Object)this.zzacD, (Object)dataPoint.zzacD) && this.zzacT == dataPoint.zzacT && this.zzacU == dataPoint.zzacU && Arrays.equals(this.zzacV, dataPoint.zzacV) && zzu.equal((Object)this.zzacW, (Object)dataPoint.zzacW);
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzacD, this.zzacT, this.zzacU});
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.zzacV), this.zzacU, this.zzacT, this.zzacX, this.zzacY, this.zzacD.toDebugString(), this.zzacW != null ? this.zzacW.toDebugString() : "N/A");
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    public long getTimestampNanos() {
        return this.zzacT;
    }

    public long zzoJ() {
        return this.zzacU;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzd.zza(this, parcel, flags);
    }

    private static long zza(Long l, long l2) {
        return l != null ? l : l2;
    }
}

