/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient var1, DataType var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private final DataType zzacC;
        private DataSource zzacD;
        private long zzGX;
        private long zzacE;
        private String zzacF;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.mContext = context;
            this.zzacC = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long start, long end, TimeUnit timeUnit) {
            this.zzGX = timeUnit.toMillis(start);
            this.zzacE = timeUnit.toMillis(end);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            zzv.zzb((boolean)dataSource.getDataType().equals(this.zzacC), (String)"Data source %s is not for the data type %s", (Object[])new Object[]{dataSource, this.zzacC});
            this.zzacD = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String packageName) {
            this.zzacF = packageName;
            return this;
        }

        public Intent build() {
            zzv.zza((this.zzGX > 0L ? 1 : 0) != 0, (Object)"Start time must be set");
            zzv.zza((this.zzacE > this.zzGX ? 1 : 0) != 0, (Object)"End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.zzacD.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.zzGX);
            intent.putExtra("vnd.google.fitness.end_time", this.zzacE);
            zzc.zza((SafeParcelable)this.zzacD, (Intent)intent, (String)"vnd.google.fitness.data_source");
            return this.zzi(intent);
        }

        private Intent zzi(Intent intent) {
            if (this.zzacF == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.zzacF);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.zzacF, string));
                return intent2;
            }
            return intent;
        }
    }
}

