/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.zzk;
import com.google.android.gms.fitness.service.SensorEventDispatcher;
import com.google.android.gms.fitness.service.zza;
import com.google.android.gms.fitness.service.zzb;
import java.util.concurrent.TimeUnit;

public class FitnessSensorServiceRequest
implements SafeParcelable {
    public static final int UNSPECIFIED = -1;
    private final int zzFG;
    private final DataSource zzYp;
    private final zzk zzabp;
    private final long zzabX;
    private final long zzabY;
    public static final Parcelable.Creator<FitnessSensorServiceRequest> CREATOR = new zza();

    FitnessSensorServiceRequest(int versionCode, DataSource dataSource, IBinder listenerBinder, long samplingRateMicros, long batchIntervalMicros) {
        this.zzFG = versionCode;
        this.zzYp = dataSource;
        this.zzabp = zzk.zza.zzav(listenerBinder);
        this.zzabX = samplingRateMicros;
        this.zzabY = batchIntervalMicros;
    }

    public DataSource getDataSource() {
        return this.zzYp;
    }

    public SensorEventDispatcher getDispatcher() {
        return new zzb(this.zzabp);
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return this.zzabX == -1L ? -1L : timeUnit.convert(this.zzabX, TimeUnit.MICROSECONDS);
    }

    public long getBatchInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzabY, TimeUnit.MICROSECONDS);
    }

    public String toString() {
        return String.format("FitnessSensorServiceRequest{%s}", this.zzYp);
    }

    int getVersionCode() {
        return this.zzFG;
    }

    IBinder zzmg() {
        return this.zzabp.asBinder();
    }

    public long zzlI() {
        return this.zzabX;
    }

    public long zzmw() {
        return this.zzabY;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zza.zza(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FitnessSensorServiceRequest && this.zza((FitnessSensorServiceRequest)that);
    }

    private boolean zza(FitnessSensorServiceRequest fitnessSensorServiceRequest) {
        return zzw.equal((Object)this.zzYp, (Object)fitnessSensorServiceRequest.zzYp) && this.zzabX == fitnessSensorServiceRequest.zzabX && this.zzabY == fitnessSensorServiceRequest.zzabY;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzYp, this.zzabX, this.zzabY});
    }
}

