/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.app.AppOpsManager;
import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.DataSourcesResult;
import com.google.android.gms.fitness.service.FitnessSensorServiceRequest;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zznv;
import com.google.android.gms.internal.zzok;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzoo;
import java.util.List;

public abstract class FitnessSensorService
extends Service {
    public static final String SERVICE_INTERFACE = "com.google.android.gms.fitness.service.FitnessSensorService";
    private zza zzabV;

    public void onCreate() {
        super.onCreate();
        this.zzabV = new zza(this);
    }

    public final IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            if (Log.isLoggable((String)"FitnessSensorService", (int)3)) {
                Log.d((String)"FitnessSensorService", (String)("Intent " + intent + " received by " + ((Object)((Object)this)).getClass().getName()));
            }
            return this.zzabV.asBinder();
        }
        return null;
    }

    public abstract List<DataSource> onFindDataSources(List<DataType> var1);

    public abstract boolean onRegister(FitnessSensorServiceRequest var1);

    public abstract boolean onUnregister(DataSource var1);

    protected void zzmv() throws SecurityException {
        int n = Binder.getCallingUid();
        String string = "com.google.android.gms";
        if (zzme.zzkj()) {
            AppOpsManager appOpsManager = (AppOpsManager)this.getSystemService("appops");
            appOpsManager.checkPackage(n, "com.google.android.gms");
            return;
        }
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!string2.equals("com.google.android.gms")) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized caller");
    }

    private static class zza
    extends zzoo.zza {
        private final FitnessSensorService zzabW;

        private zza(FitnessSensorService fitnessSensorService) {
            this.zzabW = fitnessSensorService;
        }

        @Override
        public void zza(zzok zzok2, zznh zznh2) throws RemoteException {
            this.zzabW.zzmv();
            List<DataSource> list = this.zzabW.onFindDataSources(zzok2.getDataTypes());
            zznh2.zza(new DataSourcesResult(list, Status.zzNo));
        }

        @Override
        public void zza(FitnessSensorServiceRequest fitnessSensorServiceRequest, zznv zznv2) throws RemoteException {
            this.zzabW.zzmv();
            if (this.zzabW.onRegister(fitnessSensorServiceRequest)) {
                zznv2.zzi(Status.zzNo);
            } else {
                zznv2.zzi(new Status(13));
            }
        }

        @Override
        public void zza(zzom zzom2, zznv zznv2) throws RemoteException {
            this.zzabW.zzmv();
            if (this.zzabW.onUnregister(zzom2.getDataSource())) {
                zznv2.zzi(Status.zzNo);
            } else {
                zznv2.zzi(new Status(13));
            }
        }
    }
}

