/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzq;
import com.google.android.gms.fitness.result.zzl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
implements Result,
SafeParcelable {
    private final int zzFG;
    private final List<Session> zzaaP;
    private final List<zzq> zzabU;
    private final Status zzHb;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzl();

    SessionReadResult(int versionCode, List<Session> sessions, List<zzq> sessionDataSets, Status status) {
        this.zzFG = versionCode;
        this.zzaaP = sessions;
        this.zzabU = Collections.unmodifiableList(sessionDataSets);
        this.zzHb = status;
    }

    public SessionReadResult(List<Session> sessions, List<zzq> sessionDataSets, Status status) {
        this.zzFG = 3;
        this.zzaaP = sessions;
        this.zzabU = Collections.unmodifiableList(sessionDataSets);
        this.zzHb = status;
    }

    public static SessionReadResult zzF(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<zzq> arrayList2 = new ArrayList<zzq>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzaaP;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzx.zzb((boolean)this.zzaaP.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (zzq zzq2 : this.zzabU) {
            if (!zzw.equal((Object)session, (Object)zzq2.getSession()) || !dataType.equals(zzq2.zzlH().getDataType())) continue;
            arrayList.add(zzq2.zzlH());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzx.zzb((boolean)this.zzaaP.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (zzq zzq2 : this.zzabU) {
            if (!zzw.equal((Object)session, (Object)zzq2.getSession())) continue;
            arrayList.add(zzq2.zzlH());
        }
        return arrayList;
    }

    public List<zzq> zzmt() {
        return this.zzabU;
    }

    public Status getStatus() {
        return this.zzHb;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SessionReadResult && this.zzb((SessionReadResult)that);
    }

    private boolean zzb(SessionReadResult sessionReadResult) {
        return this.zzHb.equals((Object)sessionReadResult.zzHb) && zzw.equal(this.zzaaP, sessionReadResult.zzaaP) && zzw.equal(this.zzabU, sessionReadResult.zzabU);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzHb, this.zzaaP, this.zzabU});
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("status", (Object)this.zzHb).zza("sessions", this.zzaaP).zza("sessionDataSets", this.zzabU).toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzl.zza(this, dest, flags);
    }
}

