/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.zzi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
implements Result,
SafeParcelable {
    private final int zzFG;
    private final List<Subscription> zzabT;
    private final Status zzHb;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new zzi();

    ListSubscriptionsResult(int versionCode, List<Subscription> subscriptions, Status status) {
        this.zzFG = versionCode;
        this.zzabT = subscriptions;
        this.zzHb = status;
    }

    public ListSubscriptionsResult(List<Subscription> subscriptions, Status status) {
        this.zzFG = 3;
        this.zzabT = Collections.unmodifiableList(subscriptions);
        this.zzHb = (Status)zzx.zzb((Object)status, (Object)"status");
    }

    public static ListSubscriptionsResult zzE(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.zzabT;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : this.zzabT) {
            if (!dataType.equals(subscription.zzlJ())) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzHb;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ListSubscriptionsResult && this.zzb((ListSubscriptionsResult)that);
    }

    private boolean zzb(ListSubscriptionsResult listSubscriptionsResult) {
        return this.zzHb.equals((Object)listSubscriptionsResult.zzHb) && zzw.equal(this.zzabT, listSubscriptionsResult.zzabT);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzHb, this.zzabT});
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("status", (Object)this.zzHb).zza("subscriptions", this.zzabT).toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzi.zza(this, dest, flags);
    }
}

