/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataSourcesResult
implements Result,
SafeParcelable {
    private final int zzFG;
    private final List<DataSource> zzaaO;
    private final Status zzHb;
    public static final Parcelable.Creator<DataSourcesResult> CREATOR = new zze();

    DataSourcesResult(int versionCode, List<DataSource> dataSources, Status status) {
        this.zzFG = versionCode;
        this.zzaaO = Collections.unmodifiableList(dataSources);
        this.zzHb = status;
    }

    public DataSourcesResult(List<DataSource> dataSources, Status status) {
        this.zzFG = 3;
        this.zzaaO = Collections.unmodifiableList(dataSources);
        this.zzHb = status;
    }

    public static DataSourcesResult zzC(Status status) {
        return new DataSourcesResult(Collections.emptyList(), status);
    }

    public List<DataSource> getDataSources() {
        return this.zzaaO;
    }

    public List<DataSource> getDataSources(DataType dataType) {
        ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
        for (DataSource dataSource : this.zzaaO) {
            if (!dataSource.getDataType().equals(dataType)) continue;
            arrayList.add(dataSource);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzHb;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSourcesResult && this.zzb((DataSourcesResult)that);
    }

    private boolean zzb(DataSourcesResult dataSourcesResult) {
        return this.zzHb.equals((Object)dataSourcesResult.zzHb) && zzw.equal(this.zzaaO, dataSourcesResult.zzaaO);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzHb, this.zzaaO});
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("status", (Object)this.zzHb).zza("dataSets", this.zzaaO).toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zze.zza(this, dest, flags);
    }
}

