/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.zzb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int zzFG;
    private final List<DataSet> zzYD;
    private final Status zzHb;
    private final List<Bucket> zzabM;
    private int zzabN;
    private final List<DataSource> zzYN;
    private final List<DataType> zzabO;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzb();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.zzFG = versionCode;
        this.zzHb = status;
        this.zzabN = batchCount;
        this.zzYN = uniqueDataSources;
        this.zzabO = uniqueDataTypes;
        this.zzYD = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet object : dataSets) {
            this.zzYD.add(new DataSet(object, uniqueDataSources));
        }
        this.zzabM = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.zzabM.add(new Bucket(rawBucket, uniqueDataSources));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.zzFG = 5;
        this.zzYD = dataSets;
        this.zzHb = status;
        this.zzabM = buckets;
        this.zzabN = 1;
        this.zzYN = new ArrayList<DataSource>();
        this.zzabO = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource object : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(object));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzYD) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataType.getName()));
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzYD) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataSource.getStreamIdentifier()));
    }

    public List<DataSet> getDataSets() {
        return this.zzYD;
    }

    public List<Bucket> getBuckets() {
        return this.zzabM;
    }

    public int zzmn() {
        return this.zzabN;
    }

    public void zzb(DataReadResult dataReadResult) {
        for (DataSet object : dataReadResult.getDataSets()) {
            this.zza(object, this.zzYD);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.zza(bucket, this.zzabM);
        }
    }

    private void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void zza(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.zzb(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.zza(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.zzabM.add(bucket);
    }

    public Status getStatus() {
        return this.zzHb;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.zzc((DataReadResult)that);
    }

    private boolean zzc(DataReadResult dataReadResult) {
        return this.zzHb.equals((Object)dataReadResult.zzHb) && zzw.equal(this.zzYD, dataReadResult.zzYD) && zzw.equal(this.zzabM, dataReadResult.zzabM);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzHb, this.zzYD, this.zzabM});
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("status", (Object)this.zzHb).zza("dataSets", this.zzYD.size() > 5 ? this.zzYD.size() + " data sets" : this.zzYD).zza("buckets", this.zzabM.size() > 5 ? this.zzabM.size() + " buckets" : this.zzabM).toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    List<RawBucket> zzmo() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzabM.size());
        for (Bucket bucket : this.zzabM) {
            arrayList.add(new RawBucket(bucket, this.zzYN, this.zzabO));
        }
        return arrayList;
    }

    List<RawDataSet> zzmp() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.zzYD.size());
        for (DataSet dataSet : this.zzYD) {
            arrayList.add(new RawDataSet(dataSet, this.zzYN, this.zzabO));
        }
        return arrayList;
    }

    List<DataSource> zzlx() {
        return this.zzYN;
    }

    List<DataType> zzmq() {
        return this.zzabO;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzb.zza(this, dest, flags);
    }
}

