/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzaq;
import com.google.android.gms.fitness.request.zzt;
import com.google.android.gms.internal.zzls;
import com.google.android.gms.internal.zznv;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
implements SafeParcelable {
    private final int zzFG;
    private final List<DataType> zzYA;
    private final zzt zzabH;
    private final int zzabI;
    private final zznv zzaaN;
    private final String zzFO;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzaq();

    StartBleScanRequest(int versionCode, List<DataType> dataTypes, IBinder bleScanCallback, int timeoutSecs, IBinder callback, String packageName) {
        this.zzFG = versionCode;
        this.zzYA = dataTypes;
        this.zzabH = zzt.zza.zzaV(bleScanCallback);
        this.zzabI = timeoutSecs;
        this.zzaaN = callback == null ? null : zznv.zza.zzaS(callback);
        this.zzFO = packageName;
    }

    private StartBleScanRequest(Builder builder) {
        this(zzls.zzb((Object[])builder.zzabg), builder.zzabH, builder.zzabI, null, null);
    }

    public StartBleScanRequest(StartBleScanRequest request, zznv callback, String packageName) {
        this(request.zzYA, request.zzabH, request.zzabI, callback, packageName);
    }

    public StartBleScanRequest(List<DataType> dataTypes, zzt bleScanCallback, int timeoutSecs, zznv callback, String packageName) {
        this.zzFG = 3;
        this.zzYA = dataTypes;
        this.zzabH = bleScanCallback;
        this.zzabI = timeoutSecs;
        this.zzaaN = callback;
        this.zzFO = packageName;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzYA);
    }

    public int getTimeoutSecs() {
        return this.zzabI;
    }

    public IBinder zzmk() {
        return this.zzabH.asBinder();
    }

    public IBinder zzlQ() {
        return this.zzaaN == null ? null : this.zzaaN.asBinder();
    }

    public String getPackageName() {
        return this.zzFO;
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("dataTypes", this.zzYA).zza("timeoutSecs", (Object)this.zzabI).toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzaq.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzabg = new DataType[0];
        private zzt zzabH;
        private int zzabI = 10;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzabg = dataTypes;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            this.zza(zza.zza.zzlO().zza(bleScanCallback));
            return this;
        }

        public Builder zza(zzt zzt2) {
            this.zzabH = zzt2;
            return this;
        }

        public Builder setTimeoutSecs(int stopTimeSecs) {
            zzx.zzb((stopTimeSecs > 0 ? 1 : 0) != 0, (Object)"Stop time must be greater than zero");
            zzx.zzb((stopTimeSecs <= 60 ? 1 : 0) != 0, (Object)"Stop time must be less than 1 minute");
            this.zzabI = stopTimeSecs;
            return this;
        }

        public StartBleScanRequest build() {
            zzx.zza((this.zzabH != null ? 1 : 0) != 0, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this);
        }
    }
}

