/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzah;
import com.google.android.gms.internal.zznt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
implements SafeParcelable {
    private final int zzFG;
    private final String zzabC;
    private final String zzyL;
    private final long zzON;
    private final long zzYq;
    private final List<DataType> zzYA;
    private final List<DataSource> zzaaO;
    private boolean zzabD;
    private final boolean zzaaZ;
    private final List<String> zzabE;
    private final zznt zzabF;
    private final String zzFO;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzah();

    SessionReadRequest(int versionCode, String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, IBinder callback, String packageName) {
        this.zzFG = versionCode;
        this.zzabC = sessionName;
        this.zzyL = sessionId;
        this.zzON = startTimeMillis;
        this.zzYq = endTimeMillis;
        this.zzYA = Collections.unmodifiableList(dataTypes);
        this.zzaaO = Collections.unmodifiableList(dataSources);
        this.zzabD = getSessionsFromAllApps;
        this.zzaaZ = serverQueriesEnabled;
        this.zzabE = excludedPackages;
        this.zzabF = callback == null ? null : zznt.zza.zzaQ(callback);
        this.zzFO = packageName;
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzabC, builder.zzyL, builder.zzON, builder.zzYq, builder.zzYA, builder.zzaaO, builder.zzabD, builder.zzaaZ, builder.zzabE, null, null);
    }

    public SessionReadRequest(SessionReadRequest request, zznt callback, String packageName) {
        this(request.zzabC, request.zzyL, request.zzON, request.zzYq, request.zzYA, request.zzaaO, request.zzabD, request.zzaaZ, request.zzabE, callback, packageName);
    }

    public SessionReadRequest(String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, zznt callback, String packageName) {
        this.zzFG = 4;
        this.zzabC = sessionName;
        this.zzyL = sessionId;
        this.zzON = startTimeMillis;
        this.zzYq = endTimeMillis;
        this.zzYA = Collections.unmodifiableList(dataTypes);
        this.zzaaO = Collections.unmodifiableList(dataSources);
        this.zzabD = getSessionsFromAllApps;
        this.zzaaZ = serverQueriesEnabled;
        this.zzabE = excludedPackages;
        this.zzabF = callback;
        this.zzFO = packageName;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzON, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzYq, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzabC;
    }

    public String getSessionId() {
        return this.zzyL;
    }

    public List<DataType> getDataTypes() {
        return this.zzYA;
    }

    public List<DataSource> getDataSources() {
        return this.zzaaO;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzabD;
    }

    public List<String> getExcludedPackages() {
        return this.zzabE;
    }

    public boolean zzlV() {
        return this.zzaaZ;
    }

    public long zzlq() {
        return this.zzYq;
    }

    public long zzlp() {
        return this.zzON;
    }

    public boolean zzmj() {
        return this.zzabD;
    }

    public IBinder zzlQ() {
        return this.zzabF == null ? null : this.zzabF.asBinder();
    }

    public String getPackageName() {
        return this.zzFO;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof SessionReadRequest && this.zzb((SessionReadRequest)o);
    }

    private boolean zzb(SessionReadRequest sessionReadRequest) {
        return zzw.equal((Object)this.zzabC, (Object)sessionReadRequest.zzabC) && this.zzyL.equals(sessionReadRequest.zzyL) && this.zzON == sessionReadRequest.zzON && this.zzYq == sessionReadRequest.zzYq && zzw.equal(this.zzYA, sessionReadRequest.zzYA) && zzw.equal(this.zzaaO, sessionReadRequest.zzaaO) && this.zzabD == sessionReadRequest.zzabD && this.zzabE.equals(sessionReadRequest.zzabE) && this.zzaaZ == sessionReadRequest.zzaaZ;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzabC, this.zzyL, this.zzON, this.zzYq});
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("sessionName", (Object)this.zzabC).zza("sessionId", (Object)this.zzyL).zza("startTimeMillis", (Object)this.zzON).zza("endTimeMillis", (Object)this.zzYq).zza("dataTypes", this.zzYA).zza("dataSources", this.zzaaO).zza("sessionsFromAllApps", (Object)this.zzabD).zza("excludedPackages", this.zzabE).zza("useServer", (Object)this.zzaaZ).toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzah.zza(this, dest, flags);
    }

    public static class Builder {
        private String zzabC;
        private String zzyL;
        private long zzON = 0L;
        private long zzYq = 0L;
        private List<DataType> zzYA = new ArrayList<DataType>();
        private List<DataSource> zzaaO = new ArrayList<DataSource>();
        private boolean zzabD = false;
        private boolean zzaaZ = false;
        private List<String> zzabE = new ArrayList<String>();

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            this.zzON = timeUnit.toMillis(startTime);
            this.zzYq = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder setSessionName(String sessionName) {
            this.zzabC = sessionName;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.zzyL = sessionId;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            if (!this.zzaaO.contains(dataSource)) {
                this.zzaaO.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzx.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            if (!this.zzYA.contains(dataType)) {
                this.zzYA.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzabD = true;
            return this;
        }

        public Builder excludePackage(String appPackageName) {
            zzx.zzb((Object)appPackageName, (Object)"Attempting to use a null package name");
            if (!this.zzabE.contains(appPackageName)) {
                this.zzabE.add(appPackageName);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaaZ = true;
            return this;
        }

        public SessionReadRequest build() {
            zzx.zzb((this.zzON > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzON});
            zzx.zzb((this.zzYq > 0L && this.zzYq > this.zzON ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzYq});
            return new SessionReadRequest(this);
        }
    }
}

