/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzag;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zznv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int zzFG;
    private final Session zzYs;
    private final List<DataSet> zzYD;
    private final List<DataPoint> zzabA;
    private final zznv zzaaN;
    private final String zzFO;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzag();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, IBinder callback, String packageName) {
        this.zzFG = versionCode;
        this.zzYs = session;
        this.zzYD = Collections.unmodifiableList(dataSets);
        this.zzabA = Collections.unmodifiableList(aggregateDataPoints);
        this.zzaaN = callback == null ? null : zznv.zza.zzaS(callback);
        this.zzFO = packageName;
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzYs, builder.zzYD, builder.zzabA, null, null);
    }

    public SessionInsertRequest(SessionInsertRequest request, zznv callback, String packageName) {
        this(request.zzYs, request.zzYD, request.zzabA, callback, packageName);
    }

    public SessionInsertRequest(Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, zznv callback, String packageName) {
        this.zzFG = 2;
        this.zzYs = session;
        this.zzYD = Collections.unmodifiableList(dataSets);
        this.zzabA = Collections.unmodifiableList(aggregateDataPoints);
        this.zzaaN = callback;
        this.zzFO = packageName;
    }

    public Session getSession() {
        return this.zzYs;
    }

    public List<DataSet> getDataSets() {
        return this.zzYD;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzabA;
    }

    public IBinder zzlQ() {
        return this.zzaaN == null ? null : this.zzaaN.asBinder();
    }

    public String getPackageName() {
        return this.zzFO;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SessionInsertRequest && this.zzb((SessionInsertRequest)o);
    }

    private boolean zzb(SessionInsertRequest sessionInsertRequest) {
        return zzw.equal((Object)this.zzYs, (Object)sessionInsertRequest.zzYs) && zzw.equal(this.zzYD, sessionInsertRequest.zzYD) && zzw.equal(this.zzabA, sessionInsertRequest.zzabA);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzYs, this.zzYD, this.zzabA});
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("session", (Object)this.zzYs).zza("dataSets", this.zzYD).zza("aggregateDataPoints", this.zzabA).toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzag.zza(this, dest, flags);
    }

    public static class Builder {
        private Session zzYs;
        private List<DataSet> zzYD = new ArrayList<DataSet>();
        private List<DataPoint> zzabA = new ArrayList<DataPoint>();
        private List<DataSource> zzabB = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.zzYs = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzx.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzx.zza((!this.zzabB.contains(dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            List<DataPoint> list = dataSet.getDataPoints();
            zzx.zzb((!list.isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzabB.add(dataSource);
            this.zzYD.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            zzx.zzb((aggregateDataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            long l = aggregateDataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = aggregateDataPoint.getEndTime(TimeUnit.NANOSECONDS);
            zzx.zzb((l > 0L && l2 > l ? 1 : 0) != 0, (String)"Aggregate data point should have valid start and end times: %s", (Object[])new Object[]{aggregateDataPoint});
            DataSource dataSource = aggregateDataPoint.getDataSource();
            zzx.zza((!this.zzabB.contains(dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            this.zzabB.add(dataSource);
            this.zzabA.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzx.zza((this.zzYs != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzx.zza((this.zzYs.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.zzmi();
            return new SessionInsertRequest(this);
        }

        private void zzd(DataPoint dataPoint) {
            this.zzf(dataPoint);
            this.zze(dataPoint);
        }

        private void zze(DataPoint dataPoint) {
            long l = this.zzYs.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzYs.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzmo.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzx.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (l4 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzf(DataPoint dataPoint) {
            long l = this.zzYs.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzYs.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzmo.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzx.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzmi() {
            for (DataSet object : this.zzYD) {
                for (DataPoint dataPoint : object.getDataPoints()) {
                    this.zzd(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.zzabA) {
                this.zzd(dataPoint);
            }
        }
    }
}

