/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzYp;
    private final DataType zzYo;
    private final long zzZQ;
    private final long zzabt;
    private final long zzabs;
    private final int zzZR;
    private final LocationRequest zzabx;
    private final long zzaby;

    private SensorRequest(Builder builder) {
        this.zzYp = builder.zzYp;
        this.zzYo = builder.zzYo;
        this.zzZQ = builder.zzZQ;
        this.zzabt = builder.zzabt;
        this.zzabs = builder.zzabs;
        this.zzZR = builder.zzZR;
        this.zzabx = null;
        this.zzaby = builder.zzaby;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.zzabx = locationRequest;
        this.zzZQ = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzabt = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzabs = this.zzZQ;
        this.zzYo = dataSource.getDataType();
        this.zzZR = SensorRequest.zza(locationRequest);
        this.zzYp = dataSource;
        long l = locationRequest.getExpirationTime();
        this.zzaby = l == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int zza(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.zzYp;
    }

    public DataType getDataType() {
        return this.zzYo;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzZQ, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzabt, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzabs, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzZR;
    }

    public long zzmh() {
        return this.zzaby;
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("dataSource", (Object)this.zzYp).zza("dataType", (Object)this.zzYo).zza("samplingRateMicros", (Object)this.zzZQ).zza("deliveryLatencyMicros", (Object)this.zzabs).zza("timeOutMicros", (Object)this.zzaby).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.zza((SensorRequest)that);
    }

    private boolean zza(SensorRequest sensorRequest) {
        return zzw.equal((Object)this.zzYp, (Object)sensorRequest.zzYp) && zzw.equal((Object)this.zzYo, (Object)sensorRequest.zzYo) && this.zzZQ == sensorRequest.zzZQ && this.zzabt == sensorRequest.zzabt && this.zzabs == sensorRequest.zzabs && this.zzZR == sensorRequest.zzZR && zzw.equal((Object)this.zzabx, (Object)sensorRequest.zzabx) && this.zzaby == sensorRequest.zzaby;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzYp, this.zzYo, this.zzZQ, this.zzabt, this.zzabs, this.zzZR, this.zzabx, this.zzaby});
    }

    public static int zzdP(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return n;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource zzYp;
        private DataType zzYo;
        private long zzZQ = -1L;
        private long zzabt = 0L;
        private long zzabs = 0L;
        private boolean zzabz = false;
        private int zzZR = 2;
        private long zzaby = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzYp = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzYo = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            zzx.zzb((interval >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzZQ = unit.toMicros(interval);
            if (!this.zzabz) {
                this.zzabt = this.zzZQ / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            zzx.zzb((fastestInterval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzabz = true;
            this.zzabt = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            zzx.zzb((interval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzabs = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.zzZR = SensorRequest.zzdP(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            zzx.zzb((timeout > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{timeout});
            zzx.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzaby = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            zzx.zza((this.zzYp != null || this.zzYo != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzx.zza((this.zzYo == null || this.zzYp == null || this.zzYo.equals(this.zzYp.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

