/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.zzk;
import com.google.android.gms.internal.zzni;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
implements SafeParcelable {
    private final int zzFG;
    private final String mName;
    private final List<Field> zzZd;
    private final zzni zzabi;
    private final String zzFO;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new zzk();

    DataTypeCreateRequest(int versionCode, String name, List<Field> fields, IBinder callback, String packageName) {
        this.zzFG = versionCode;
        this.mName = name;
        this.zzZd = Collections.unmodifiableList(fields);
        this.zzabi = callback == null ? null : zzni.zza.zzaF(callback);
        this.zzFO = packageName;
    }

    private DataTypeCreateRequest(Builder builder) {
        this(builder.mName, builder.zzZd, null, null);
    }

    public DataTypeCreateRequest(DataTypeCreateRequest request, zzni callback, String packageName) {
        this(request.mName, request.zzZd, callback, packageName);
    }

    public DataTypeCreateRequest(String name, List<Field> fields, zzni callback, String packageName) {
        this.zzFG = 2;
        this.mName = name;
        this.zzZd = Collections.unmodifiableList(fields);
        this.zzabi = callback;
        this.zzFO = packageName;
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.zzZd;
    }

    public IBinder zzlQ() {
        return this.zzabi == null ? null : this.zzabi.asBinder();
    }

    public String getPackageName() {
        return this.zzFO;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataTypeCreateRequest && this.zzb((DataTypeCreateRequest)o);
    }

    private boolean zzb(DataTypeCreateRequest dataTypeCreateRequest) {
        return zzw.equal((Object)this.mName, (Object)dataTypeCreateRequest.mName) && zzw.equal(this.zzZd, dataTypeCreateRequest.zzZd);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.mName, this.zzZd});
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("name", (Object)this.mName).zza("fields", this.zzZd).toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzk.zza(this, dest, flags);
    }

    public static class Builder {
        private String mName;
        private List<Field> zzZd = new ArrayList<Field>();

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.zzZd.contains(field)) {
                this.zzZd.add(field);
            }
            return this;
        }

        public Builder addField(String name, int format) {
            zzx.zzb((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid name specified");
            Field field = Field.zzn(name, format);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            zzx.zza((this.mName != null ? 1 : 0) != 0, (Object)"Must set the name");
            zzx.zza((!this.zzZd.isEmpty() ? 1 : 0) != 0, (Object)"Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

