/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzj;
import com.google.android.gms.internal.zzls;
import com.google.android.gms.internal.zznh;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataSourcesRequest
implements SafeParcelable {
    private final int zzFG;
    private final List<DataType> zzYA;
    private final List<Integer> zzabd;
    private final boolean zzabe;
    private final zznh zzabf;
    private final String zzFO;
    public static final Parcelable.Creator<DataSourcesRequest> CREATOR = new zzj();

    DataSourcesRequest(int versionCode, List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, IBinder callback, String packageName) {
        this.zzFG = versionCode;
        this.zzYA = dataTypes;
        this.zzabd = dataSourceTypes;
        this.zzabe = includeDbOnlySources;
        this.zzabf = callback == null ? null : zznh.zza.zzaE(callback);
        this.zzFO = packageName;
    }

    private DataSourcesRequest(Builder builder) {
        this(zzls.zzb((Object[])builder.zzabg), Arrays.asList(zzls.zza((int[])builder.zzabh)), builder.zzabe, null, null);
    }

    public DataSourcesRequest(DataSourcesRequest request, zznh callback, String packageName) {
        this(request.zzYA, request.zzabd, request.zzabe, callback, packageName);
    }

    public DataSourcesRequest(List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, zznh callback, String packageName) {
        this.zzFG = 3;
        this.zzYA = dataTypes;
        this.zzabd = dataSourceTypes;
        this.zzabe = includeDbOnlySources;
        this.zzabf = callback;
        this.zzFO = packageName;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzYA);
    }

    public List<Integer> zzlY() {
        return this.zzabd;
    }

    public boolean zzlZ() {
        return this.zzabe;
    }

    public IBinder zzlQ() {
        return this.zzabf == null ? null : this.zzabf.asBinder();
    }

    public String getPackageName() {
        return this.zzFO;
    }

    public String toString() {
        zzw.zza zza2 = zzw.zzk((Object)this).zza("dataTypes", this.zzYA).zza("sourceTypes", this.zzabd);
        if (this.zzabe) {
            zza2.zza("includeDbOnlySources", (Object)"true");
        }
        return zza2.toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzj.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzabg = new DataType[0];
        private int[] zzabh = new int[]{0, 1};
        private boolean zzabe = false;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzabg = dataTypes;
            return this;
        }

        public Builder setDataSourceTypes(int ... dataSourceTypes) {
            this.zzabh = dataSourceTypes;
            return this;
        }

        public DataSourcesRequest build() {
            zzx.zza((this.zzabg.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one data type");
            zzx.zza((this.zzabh.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one data source type");
            return new DataSourcesRequest(this);
        }
    }
}

