/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzg;
import com.google.android.gms.internal.zzng;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int zzFG;
    private final List<DataType> zzYA;
    private final List<DataSource> zzaaO;
    private final long zzON;
    private final long zzYq;
    private final List<DataType> zzaaT;
    private final List<DataSource> zzaaU;
    private final int zzYE;
    private final long zzaaV;
    private final DataSource zzaaW;
    private final int zzaaX;
    private final boolean zzaaY;
    private final boolean zzaaZ;
    private final zzng zzaba;
    private final String zzFO;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzg();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, IBinder callback, String packageName) {
        this.zzFG = versionCode;
        this.zzYA = Collections.unmodifiableList(dataTypes);
        this.zzaaO = Collections.unmodifiableList(dataSources);
        this.zzON = startTimeMillis;
        this.zzYq = endTimeMillis;
        this.zzaaT = Collections.unmodifiableList(aggregatedDataTypes);
        this.zzaaU = Collections.unmodifiableList(aggregatedDataSources);
        this.zzYE = bucketType;
        this.zzaaV = bucketDurationMillis;
        this.zzaaW = activityDataSource;
        this.zzaaX = limit;
        this.zzaaY = flushBeforeRead;
        this.zzaaZ = serverQueriesEnabled;
        this.zzaba = callback == null ? null : zzng.zza.zzaD(callback);
        this.zzFO = packageName;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzYA, builder.zzaaO, builder.zzON, builder.zzYq, builder.zzaaT, builder.zzaaU, builder.zzYE, builder.zzaaV, builder.zzaaW, builder.zzaaX, builder.zzaaY, builder.zzaaZ, null, null);
    }

    public DataReadRequest(DataReadRequest request, zzng callback, String packageName) {
        this(request.zzYA, request.zzaaO, request.zzON, request.zzYq, request.zzaaT, request.zzaaU, request.zzYE, request.zzaaV, request.zzaaW, request.zzaaX, request.zzaaY, request.zzaaZ, callback, packageName);
    }

    public DataReadRequest(List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, zzng callback, String packageName) {
        this.zzFG = 3;
        this.zzYA = Collections.unmodifiableList(dataTypes);
        this.zzaaO = Collections.unmodifiableList(dataSources);
        this.zzON = startTimeMillis;
        this.zzYq = endTimeMillis;
        this.zzaaT = Collections.unmodifiableList(aggregatedDataTypes);
        this.zzaaU = Collections.unmodifiableList(aggregatedDataSources);
        this.zzYE = bucketType;
        this.zzaaV = bucketDurationMillis;
        this.zzaaW = activityDataSource;
        this.zzaaX = limit;
        this.zzaaY = flushBeforeRead;
        this.zzaaZ = serverQueriesEnabled;
        this.zzaba = callback;
        this.zzFO = packageName;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzON, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzYq, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzYA;
    }

    public List<DataSource> getDataSources() {
        return this.zzaaO;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzaaT;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzaaU;
    }

    public int getBucketType() {
        return this.zzYE;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaaV, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzaaW;
    }

    public int getLimit() {
        return this.zzaaX;
    }

    public boolean zzlV() {
        return this.zzaaZ;
    }

    public boolean zzlW() {
        return this.zzaaY;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.zzb((DataReadRequest)that);
    }

    private boolean zzb(DataReadRequest dataReadRequest) {
        return this.zzYA.equals(dataReadRequest.zzYA) && this.zzaaO.equals(dataReadRequest.zzaaO) && this.zzON == dataReadRequest.zzON && this.zzYq == dataReadRequest.zzYq && this.zzYE == dataReadRequest.zzYE && this.zzaaU.equals(dataReadRequest.zzaaU) && this.zzaaT.equals(dataReadRequest.zzaaT) && zzw.equal((Object)this.zzaaW, (Object)dataReadRequest.zzaaW) && this.zzaaV == dataReadRequest.zzaaV && this.zzaaZ == dataReadRequest.zzaaZ;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzYE, this.zzON, this.zzYq});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzYA.isEmpty()) {
            for (DataType object : this.zzYA) {
                stringBuilder.append(object.zzlB()).append(" ");
            }
        }
        if (!this.zzaaO.isEmpty()) {
            for (DataSource dataSource : this.zzaaO) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzYE != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzdg(this.zzYE));
            if (this.zzaaV > 0L) {
                stringBuilder.append(" >").append(this.zzaaV).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzaaT.isEmpty()) {
            for (DataType dataType : this.zzaaT) {
                stringBuilder.append(dataType.zzlB()).append(" ");
            }
        }
        if (!this.zzaaU.isEmpty()) {
            for (DataSource dataSource : this.zzaaU) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzON, this.zzON, this.zzYq, this.zzYq));
        if (this.zzaaW != null) {
            stringBuilder.append("activities: ").append(this.zzaaW.toDebugString());
        }
        if (this.zzaaZ) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public long zzlq() {
        return this.zzYq;
    }

    public long zzlp() {
        return this.zzON;
    }

    public long zzlX() {
        return this.zzaaV;
    }

    public IBinder zzlQ() {
        return this.zzaba == null ? null : this.zzaba.asBinder();
    }

    public String getPackageName() {
        return this.zzFO;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzg.zza(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> zzYA = new ArrayList<DataType>();
        private List<DataSource> zzaaO = new ArrayList<DataSource>();
        private List<DataType> zzaaT = new ArrayList<DataType>();
        private List<DataSource> zzaaU = new ArrayList<DataSource>();
        private DataSource zzaaW;
        private long zzON;
        private long zzYq;
        private int zzYE = 0;
        private long zzaaV = 0L;
        private int zzaaX = 0;
        private boolean zzaaY = false;
        private boolean zzaaZ = false;

        public Builder read(DataSource dataSource) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzx.zzb((!this.zzaaU.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzaaO.contains(dataSource)) {
                this.zzaaO.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzx.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            zzx.zza((!this.zzaaT.contains(dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzYA.contains(dataType)) {
                this.zzYA.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzx.zza((!this.zzaaO.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            zzx.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(dataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzx.zzb((boolean)DataType.getAggregatesForInput(dataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, outputDataType});
            if (!this.zzaaU.contains(dataSource)) {
                this.zzaaU.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            zzx.zzb((Object)inputDataType, (Object)"Attempting to use a null data type");
            zzx.zza((!this.zzYA.contains(inputDataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            zzx.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(inputDataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{inputDataType});
            zzx.zzb((boolean)DataType.getAggregatesForInput(inputDataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{inputDataType, outputDataType});
            if (!this.zzaaT.contains(inputDataType)) {
                this.zzaaT.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            zzx.zzb((this.zzYE == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzYE});
            zzx.zzb((duration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{duration});
            this.zzYE = 1;
            this.zzaaV = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzYE == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzYE});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzYE = 3;
            this.zzaaV = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzx.zzb((this.zzYE == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzYE});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzx.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzx.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzaaW = activityDataSource;
            this.zzYE = 3;
            this.zzaaV = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzYE == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzYE});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzYE = 4;
            this.zzaaV = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzx.zzb((this.zzYE == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzYE});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzx.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzx.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzaaW = activityDataSource;
            this.zzYE = 4;
            this.zzaaV = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzYE == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzYE});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzYE = 2;
            this.zzaaV = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long start, long end, TimeUnit timeUnit) {
            this.zzON = timeUnit.toMillis(start);
            this.zzYq = timeUnit.toMillis(end);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaaZ = true;
            return this;
        }

        public Builder setLimit(int limit) {
            zzx.zzb((limit > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{limit});
            this.zzaaX = limit;
            return this;
        }

        public DataReadRequest build() {
            zzx.zza((!this.zzaaO.isEmpty() || !this.zzYA.isEmpty() || !this.zzaaU.isEmpty() || !this.zzaaT.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzx.zza((this.zzON > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzON});
            zzx.zza((this.zzYq > 0L && this.zzYq > this.zzON ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzYq});
            boolean bl = this.zzaaU.isEmpty() && this.zzaaT.isEmpty();
            zzx.zza((bl && this.zzYE == 0 || !bl && this.zzYE != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

