/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.internal.zznv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int zzFG;
    private final long zzON;
    private final long zzYq;
    private final List<DataSource> zzaaO;
    private final List<DataType> zzYA;
    private final List<Session> zzaaP;
    private final boolean zzaaQ;
    private final boolean zzaaR;
    private final zznv zzaaN;
    private final String zzFO;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzd();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, IBinder callback, String packageName) {
        this.zzFG = versionCode;
        this.zzON = startTimeMillis;
        this.zzYq = endTimeMillis;
        this.zzaaO = Collections.unmodifiableList(dataSources);
        this.zzYA = Collections.unmodifiableList(dataTypes);
        this.zzaaP = sessions;
        this.zzaaQ = deleteAllData;
        this.zzaaR = deleteAllSessions;
        this.zzaaN = callback == null ? null : zznv.zza.zzaS(callback);
        this.zzFO = packageName;
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzON, builder.zzYq, builder.zzaaO, builder.zzYA, builder.zzaaP, builder.zzaaQ, builder.zzaaR, null, null);
    }

    public DataDeleteRequest(DataDeleteRequest request, zznv callback, String packageName) {
        this(request.zzON, request.zzYq, request.zzaaO, request.zzYA, request.zzaaP, request.zzaaQ, request.zzaaR, callback, packageName);
    }

    public DataDeleteRequest(long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, zznv callback, String packageName) {
        this.zzFG = 2;
        this.zzON = startTimeMillis;
        this.zzYq = endTimeMillis;
        this.zzaaO = Collections.unmodifiableList(dataSources);
        this.zzYA = Collections.unmodifiableList(dataTypes);
        this.zzaaP = sessions;
        this.zzaaQ = deleteAllData;
        this.zzaaR = deleteAllSessions;
        this.zzaaN = callback;
        this.zzFO = packageName;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzON, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzYq, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzaaO;
    }

    public List<DataType> getDataTypes() {
        return this.zzYA;
    }

    public List<Session> getSessions() {
        return this.zzaaP;
    }

    public boolean deleteAllData() {
        return this.zzaaQ;
    }

    public boolean deleteAllSessions() {
        return this.zzaaR;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataDeleteRequest && this.zzb((DataDeleteRequest)o);
    }

    private boolean zzb(DataDeleteRequest dataDeleteRequest) {
        return this.zzON == dataDeleteRequest.zzON && this.zzYq == dataDeleteRequest.zzYq && zzw.equal(this.zzaaO, dataDeleteRequest.zzaaO) && zzw.equal(this.zzYA, dataDeleteRequest.zzYA) && zzw.equal(this.zzaaP, dataDeleteRequest.zzaaP) && this.zzaaQ == dataDeleteRequest.zzaaQ && this.zzaaR == dataDeleteRequest.zzaaR;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzON, this.zzYq});
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("startTimeMillis", (Object)this.zzON).zza("endTimeMillis", (Object)this.zzYq).zza("dataSources", this.zzaaO).zza("dateTypes", this.zzYA).zza("sessions", this.zzaaP).zza("deleteAllData", (Object)this.zzaaQ).zza("deleteAllSessions", (Object)this.zzaaR).toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public boolean zzlR() {
        return this.zzaaQ;
    }

    public boolean zzlS() {
        return this.zzaaR;
    }

    public long zzlq() {
        return this.zzYq;
    }

    public long zzlp() {
        return this.zzON;
    }

    public IBinder zzlQ() {
        return this.zzaaN == null ? null : this.zzaaN.asBinder();
    }

    public String getPackageName() {
        return this.zzFO;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzd.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzON;
        private long zzYq;
        private List<DataSource> zzaaO = new ArrayList<DataSource>();
        private List<DataType> zzYA = new ArrayList<DataType>();
        private List<Session> zzaaP = new ArrayList<Session>();
        private boolean zzaaQ = false;
        private boolean zzaaR = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            zzx.zzb((startTime > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{startTime});
            zzx.zzb((endTime > startTime ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{endTime});
            this.zzON = timeUnit.toMillis(startTime);
            this.zzYq = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            zzx.zzb((this.zzYA.isEmpty() && this.zzaaO.isEmpty() ? 1 : 0) != 0, (String)"Specific data source/type already specified for deletion. DataSources: %s DataTypes: %s", (Object[])new Object[]{this.zzaaO, this.zzYA});
            this.zzaaQ = true;
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzx.zzb((!this.zzaaQ ? 1 : 0) != 0, (Object)"All data is already marked for deletion");
            zzx.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzaaO.contains(dataSource)) {
                this.zzaaO.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzx.zzb((!this.zzaaR ? 1 : 0) != 0, (Object)"All sessions already marked for deletion");
            zzx.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzx.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Must specify a session that has already ended");
            this.zzaaP.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzx.zzb((boolean)this.zzaaP.isEmpty(), (String)"Specific sessions already added for deletion: %s", (Object[])new Object[]{this.zzaaP});
            this.zzaaR = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzx.zzb((!this.zzaaQ ? 1 : 0) != 0, (Object)"All data is already marked for deletion");
            zzx.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzYA.contains(dataType)) {
                this.zzYA.add(dataType);
            }
            return this;
        }

        public DataDeleteRequest build() {
            zzx.zza((this.zzON > 0L && this.zzYq > this.zzON ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzaaQ || !this.zzaaO.isEmpty() || !this.zzYA.isEmpty();
            boolean bl2 = this.zzaaR || !this.zzaaP.isEmpty();
            zzx.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            this.zzlT();
            return new DataDeleteRequest(this);
        }

        private void zzlT() {
            if (this.zzaaP.isEmpty()) {
                return;
            }
            for (Session session : this.zzaaP) {
                zzx.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= this.zzON && session.getEndTime(TimeUnit.MILLISECONDS) <= this.zzYq ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, this.zzON, this.zzYq});
            }
        }
    }
}

