/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.zzu;

public final class Value
implements SafeParcelable {
    private final int zzFG;
    private final int zzZE;
    private boolean zzZS;
    private float zzZT;
    public static final Parcelable.Creator<Value> CREATOR = new zzu();

    public Value(int format) {
        this(1, format, false, 0.0f);
    }

    Value(int versionCode, int format, boolean isSet, float value) {
        this.zzFG = versionCode;
        this.zzZE = format;
        this.zzZS = isSet;
        this.zzZT = value;
    }

    public void setInt(int value) {
        zzx.zza((this.zzZE == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzZS = true;
        this.zzZT = Float.intBitsToFloat(value);
    }

    public void setFloat(float value) {
        zzx.zza((this.zzZE == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzZS = true;
        this.zzZT = value;
    }

    public void setActivity(String activity) {
        this.setInt(FitnessActivities.zzbG(activity));
    }

    public boolean isSet() {
        return this.zzZS;
    }

    public int getFormat() {
        return this.zzZE;
    }

    public int asInt() {
        zzx.zza((this.zzZE == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.zzZT);
    }

    public float asFloat() {
        zzx.zza((this.zzZE == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.zzZT;
    }

    public String asActivity() {
        return FitnessActivities.getName(this.asInt());
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Value && this.zza((Value)o);
    }

    private boolean zza(Value value) {
        if (this.zzZE == value.zzZE && this.zzZS == value.zzZS) {
            switch (this.zzZE) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.asFloat() == value.asFloat();
                }
            }
            return this.zzZT == value.zzZT;
        }
        return false;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{Float.valueOf(this.zzZT), this.zzZE, this.zzZS});
    }

    public String toString() {
        if (!this.zzZS) {
            return "unset";
        }
        switch (this.zzZE) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.asFloat());
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.zzFG;
    }

    float zzlL() {
        return this.zzZT;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzu.zza(this, dest, flags);
    }
}

