/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.zza;
import com.google.android.gms.fitness.data.zzp;
import java.util.concurrent.TimeUnit;

public class Session
implements SafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int zzFG;
    private final long zzON;
    private final long zzYq;
    private final String mName;
    private final String zzZN;
    private final String zzZO;
    private final int zzYC;
    private final zza zzYP;
    public static final Parcelable.Creator<Session> CREATOR = new zzp();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, zza application) {
        this.zzFG = versionCode;
        this.zzON = startTimeMillis;
        this.zzYq = endTimeMillis;
        this.mName = name;
        this.zzZN = identifier;
        this.zzZO = description;
        this.zzYC = activityType;
        this.zzYP = application;
    }

    private Session(Builder builder) {
        this.zzFG = 2;
        this.zzON = builder.zzON;
        this.zzYq = builder.zzYq;
        this.mName = builder.mName;
        this.zzZN = builder.zzZN;
        this.zzZO = builder.zzZO;
        this.zzYC = builder.zzYC;
        this.zzYP = builder.zzYP;
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzc.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzON, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzYq, TimeUnit.MILLISECONDS);
    }

    public boolean isOngoing() {
        return this.zzYq == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzZN;
    }

    public String getDescription() {
        return this.zzZO;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzYC);
    }

    public int zzln() {
        return this.zzYC;
    }

    public zza zzlz() {
        return this.zzYP;
    }

    public String getAppPackageName() {
        return this.zzYP == null ? null : this.zzYP.getPackageName();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Session && this.zza((Session)o);
    }

    private boolean zza(Session session) {
        return this.zzON == session.zzON && this.zzYq == session.zzYq && zzw.equal((Object)this.mName, (Object)session.mName) && zzw.equal((Object)this.zzZN, (Object)session.zzZN) && zzw.equal((Object)this.zzZO, (Object)session.zzZO) && zzw.equal((Object)this.zzYP, (Object)session.zzYP) && this.zzYC == session.zzYC;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzON, this.zzYq, this.zzZN});
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("startTime", (Object)this.zzON).zza("endTime", (Object)this.zzYq).zza("name", (Object)this.mName).zza("identifier", (Object)this.zzZN).zza("description", (Object)this.zzZO).zza("activity", (Object)this.zzYC).zza("application", (Object)this.zzYP).toString();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public long zzlp() {
        return this.zzON;
    }

    public long zzlq() {
        return this.zzYq;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzp.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzON = 0L;
        private long zzYq = 0L;
        private String mName = null;
        private String zzZN;
        private String zzZO;
        private int zzYC = 4;
        private zza zzYP;

        public Builder setStartTime(long time, TimeUnit timeUnit) {
            zzx.zza((time > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzON = timeUnit.toMillis(time);
            return this;
        }

        public Builder setEndTime(long time, TimeUnit timeUnit) {
            zzx.zza((time >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzYq = timeUnit.toMillis(time);
            return this;
        }

        public Builder setName(String name) {
            zzx.zzb((name.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            zzx.zzO((identifier != null && TextUtils.getTrimmedLength((CharSequence)identifier) > 0 ? 1 : 0) != 0);
            this.zzZN = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            zzx.zzb((description.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzZO = description;
            return this;
        }

        public Builder setActivity(String activity) {
            return this.zzds(FitnessActivities.zzbG(activity));
        }

        public Builder zzds(int n) {
            this.zzYC = n;
            return this;
        }

        public Builder zzbL(String string) {
            this.zzYP = zza.zzbI(string);
            return this;
        }

        public Session build() {
            zzx.zza((this.zzON > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzx.zza((this.zzYq == 0L || this.zzYq > this.zzON ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzZN == null) {
                this.zzZN = (this.mName == null ? "" : this.mName) + this.zzON;
            }
            return new Session(this);
        }
    }
}

