/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzm;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawBucket
implements SafeParcelable {
    final int zzFG;
    public final long zzON;
    public final long zzYq;
    public final Session zzYs;
    public final int zzZI;
    public final List<RawDataSet> zzYD;
    public final int zzYE;
    public final boolean zzYF;
    public static final Parcelable.Creator<RawBucket> CREATOR = new zzm();

    public RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.zzFG = versionCode;
        this.zzON = startTimeMillis;
        this.zzYq = endTimeMillis;
        this.zzYs = session;
        this.zzZI = activity;
        this.zzYD = dataSets;
        this.zzYE = bucketType;
        this.zzYF = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.zzFG = 2;
        this.zzON = bucket.getStartTime(TimeUnit.MILLISECONDS);
        this.zzYq = bucket.getEndTime(TimeUnit.MILLISECONDS);
        this.zzYs = bucket.getSession();
        this.zzZI = bucket.zzln();
        this.zzYE = bucket.getBucketType();
        this.zzYF = bucket.zzlo();
        List<DataSet> list = bucket.getDataSets();
        this.zzYD = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.zzYD.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RawBucket && this.zza((RawBucket)o);
    }

    private boolean zza(RawBucket rawBucket) {
        return this.zzON == rawBucket.zzON && this.zzYq == rawBucket.zzYq && this.zzZI == rawBucket.zzZI && zzw.equal(this.zzYD, rawBucket.zzYD) && this.zzYE == rawBucket.zzYE && this.zzYF == rawBucket.zzYF;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzON, this.zzYq, this.zzYE});
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("startTime", (Object)this.zzON).zza("endTime", (Object)this.zzYq).zza("activity", (Object)this.zzZI).zza("dataSets", this.zzYD).zza("bucketType", (Object)this.zzYE).zza("serverHasMoreData", (Object)this.zzYF).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzm.zza(this, parcel, flags);
    }
}

