/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.zzi;
import com.google.android.gms.internal.zznz;

public final class Device
implements SafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int zzFG;
    private final String zzZe;
    private final String zzZf;
    private final String zzYw;
    private final String zzZg;
    private final int zzJp;
    private final int zzZh;
    public static final Parcelable.Creator<Device> CREATOR = new zzi();

    public static Device getLocalDevice(Context context) {
        int n = Device.zzU(context);
        String string = Device.zzT(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    private static String zzT(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    private static int zzU(Context context) {
        switch (Device.zzW(context)) {
            case 10: {
                return Device.zzV(context) ? 3 : 0;
            }
            case 8: 
            case 9: {
                return 0;
            }
        }
        return Device.zzY(context) ? 1 : 2;
    }

    public static boolean zzV(Context context) {
        Configuration configuration = context.getResources().getConfiguration();
        return (configuration.uiMode & 0xF) == 6;
    }

    private static int zzW(Context context) {
        return Device.zzX(context) % 1000 / 100 + 5;
    }

    private static int zzX(Context context) {
        try {
            String string = "com.google.android.gms";
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string, 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"Fitness", (String)"Could not find package info for Google Play Services");
            return -1;
        }
    }

    private static boolean zzY(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getPhoneType() != 0;
    }

    public Device(String manufacturer, String model, String uid, int type) {
        this(manufacturer, model, "", uid, type, 0);
    }

    public Device(String manufacturer, String model, String version, String uid, int type) {
        this(manufacturer, model, uid, type);
    }

    public Device(String manufacturer, String model, String version, String uid, int type, int platformType) {
        this(1, manufacturer, model, "", uid, type, platformType);
    }

    Device(int versionCode, String manufacturer, String model, String version, String uid, int type, int platformType) {
        this.zzFG = versionCode;
        this.zzZe = (String)zzx.zzl((Object)manufacturer);
        this.zzZf = (String)zzx.zzl((Object)model);
        this.zzYw = "";
        this.zzZg = (String)zzx.zzl((Object)uid);
        this.zzJp = type;
        this.zzZh = platformType;
    }

    public String getManufacturer() {
        return this.zzZe;
    }

    public String getModel() {
        return this.zzZf;
    }

    public String getVersion() {
        return this.zzYw;
    }

    public String getUid() {
        return this.zzZg;
    }

    public int getType() {
        return this.zzJp;
    }

    public int zzlD() {
        return this.zzZh;
    }

    private boolean zzlE() {
        return this.zzlD() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzZe, this.zzZf, this.zzZg);
    }

    public String zzlF() {
        return zznz.zzlM() || this.zzlE() ? this.zzZg : zznz.zzbM(this.zzZg);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.zzYw, this.zzJp, this.zzZh);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Device && this.zza((Device)that);
    }

    private boolean zza(Device device) {
        return zzw.equal((Object)this.zzZe, (Object)device.zzZe) && zzw.equal((Object)this.zzZf, (Object)device.zzZf) && zzw.equal((Object)this.zzYw, (Object)device.zzYw) && zzw.equal((Object)this.zzZg, (Object)device.zzZg) && this.zzJp == device.zzJp && this.zzZh == device.zzZh;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzZe, this.zzZf, this.zzYw, this.zzZg, this.zzJp});
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzi.zza(this, parcel, flags);
    }
}

