/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zza;
import com.google.android.gms.fitness.data.zzg;
import com.google.android.gms.internal.zznz;
import com.google.android.gms.internal.zzxc;

public class DataSource
implements SafeParcelable {
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int zzFG;
    private final DataType zzYo;
    private final String mName;
    private final int zzJp;
    private final Device zzYO;
    private final zza zzYP;
    private final String zzYQ;
    private final String zzYR;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzg();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, zza application, String streamName) {
        this.zzFG = versionCode;
        this.zzYo = dataType;
        this.zzJp = type;
        this.mName = name;
        this.zzYO = device;
        this.zzYP = application;
        this.zzYQ = streamName;
        this.zzYR = this.zzlA();
    }

    private DataSource(Builder builder) {
        this.zzFG = 3;
        this.zzYo = builder.zzYo;
        this.zzJp = builder.zzJp;
        this.mName = builder.mName;
        this.zzYO = builder.zzYO;
        this.zzYP = builder.zzYP;
        this.zzYQ = builder.zzYQ;
        this.zzYR = this.zzlA();
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzc.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzYo;
    }

    public zzxc.zzc zzly() {
        return this.getDataType() == null ? null : this.getDataType().zzlC();
    }

    public int getType() {
        return this.zzJp;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.zzYP == null ? null : this.zzYP.getPackageName();
    }

    public zza zzlz() {
        return this.zzYP;
    }

    public Device getDevice() {
        return this.zzYO;
    }

    public String getStreamName() {
        return this.zzYQ;
    }

    public String getStreamIdentifier() {
        return this.zzYR;
    }

    private String zzlA() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.zzYo.getName());
        if (this.zzYP != null) {
            stringBuilder.append(":").append(this.zzYP.getPackageName());
        }
        if (this.zzYO != null) {
            stringBuilder.append(":").append(this.zzYO.getStreamIdentifier());
        }
        if (this.zzYQ != null) {
            stringBuilder.append(":").append(this.zzYQ);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.zza((DataSource)that);
    }

    private boolean zza(DataSource dataSource) {
        return this.zzYR.equals(dataSource.zzYR);
    }

    public int hashCode() {
        return this.zzYR.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.zzYP != null) {
            stringBuilder.append(":").append(this.zzYP);
        }
        if (this.zzYO != null) {
            stringBuilder.append(":").append(this.zzYO);
        }
        if (this.zzYQ != null) {
            stringBuilder.append(":").append(this.zzYQ);
        }
        stringBuilder.append(":").append(this.zzYo);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.zzJp == 0 ? "r" : "d") + ":" + this.zzYo.zzlB() + (this.zzYP == null ? "" : (this.zzYP.equals(zza.zzYv) ? ":gms" : ":" + this.zzYP.getPackageName())) + (this.zzYO != null ? ":" + this.zzYO.getModel() + ":" + this.zzYO.getUid() : "") + (this.zzYQ != null ? ":" + this.zzYQ : "");
    }

    private String getTypeString() {
        switch (this.zzJp) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        DataSource dataSource = zznz.zzc(this);
        zzg.zza(dataSource, parcel, flags);
    }

    public static final class Builder {
        private DataType zzYo;
        private int zzJp = -1;
        private String mName;
        private Device zzYO;
        private zza zzYP;
        private String zzYQ = "";

        public Builder setDataType(DataType dataType) {
            this.zzYo = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.zzJp = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.zzYO = device;
            return this;
        }

        public Builder zzb(zza zza2) {
            this.zzYP = zza2;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.zzYP = zza.zzbI(packageName);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            zzx.zzb((streamName != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzYQ = streamName;
            return this;
        }

        @Deprecated
        public Builder setObfuscated(boolean isObfuscated) {
            return this;
        }

        public DataSource build() {
            zzx.zza((this.zzYo != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzx.zza((this.zzJp >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

