/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zzf;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzmv;
import com.google.android.gms.internal.zzxd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataSet
implements SafeParcelable {
    private final int zzFG;
    private final DataSource zzYp;
    private final DataType zzYo;
    private final List<DataPoint> zzYM;
    private final List<DataSource> zzYN;
    private boolean zzYF = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zzf();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.zzFG = versionCode;
        this.zzYp = dataSource;
        this.zzYo = dataSource.getDataType();
        this.zzYF = serverHasMoreData;
        this.zzYM = new ArrayList<DataPoint>(dataPoints.size());
        this.zzYN = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.zzYM.add(new DataPoint(this.zzYN, rawDataPoint));
        }
    }

    public DataSet(DataSource dataSource) {
        this.zzFG = 3;
        this.zzYp = (DataSource)zzx.zzl((Object)dataSource);
        this.zzYo = dataSource.getDataType();
        this.zzYM = new ArrayList<DataPoint>();
        this.zzYN = new ArrayList<DataSource>();
        this.zzYN.add(this.zzYp);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources) {
        this(zzmv.zzb(dataSet), uniqueDataSources);
    }

    public DataSet(zzxd.zzc dataSet, List<DataSource> uniqueDataSources) {
        this.zzFG = 3;
        this.zzYp = DataSet.zzd(uniqueDataSources, dataSet.zzaID);
        this.zzYo = this.zzYp.getDataType();
        this.zzYN = uniqueDataSources;
        this.zzYF = dataSet.zzaIx;
        List<RawDataPoint> list = zzmu.zza(DataSet.zzd(uniqueDataSources, (int)dataSet.zzaID).zzly().zzaIf, dataSet.zzaIK);
        this.zzYM = new ArrayList<DataPoint>(list.size());
        for (RawDataPoint rawDataPoint : list) {
            this.zzYM.add(new DataPoint(this.zzYN, rawDataPoint));
        }
    }

    private static <T> T zzd(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static DataSet create(DataSource dataSource) {
        zzx.zzb((Object)dataSource, (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.zzYp);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzx.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzYp.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzYp});
        zzx.zzb((boolean)dataPoint.getDataType().getName().equals(this.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{dataPoint.getDataType(), this.getDataType()});
        zzx.zzb((dataPoint.getTimestamp(TimeUnit.NANOSECONDS) > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{dataPoint});
        zzx.zzb((dataPoint.getStartTime(TimeUnit.NANOSECONDS) <= dataPoint.getEndTime(TimeUnit.NANOSECONDS) ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{dataPoint});
        this.zzb(dataPoint);
    }

    public void zzb(DataPoint dataPoint) {
        this.zzYM.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzYN.contains(dataSource)) {
            this.zzYN.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzb(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.zzYp;
    }

    public DataType getDataType() {
        return this.zzYp.getDataType();
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzYM);
    }

    public boolean zzlo() {
        return this.zzYF;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataSet && this.zza((DataSet)o);
    }

    private boolean zza(DataSet dataSet) {
        return zzw.equal((Object)this.getDataType(), (Object)dataSet.getDataType()) && zzw.equal((Object)this.zzYp, (Object)dataSet.zzYp) && zzw.equal(this.zzYM, dataSet.zzYM) && this.zzYF == dataSet.zzYF;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzYp});
    }

    public String toString() {
        List<RawDataPoint> list = this.zzlw();
        return String.format("DataSet{%s %s}", this.zzYp.toDebugString(), this.zzYM.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzYM.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.zzFG;
    }

    List<RawDataPoint> zzlw() {
        return this.zzk(this.zzYN);
    }

    List<RawDataPoint> zzk(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzYM.size());
        for (DataPoint dataPoint : this.zzYM) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> zzlx() {
        return this.zzYN;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzf.zza(this, parcel, flags);
    }
}

