/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zzxd;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int zzFG;
    private final DataSource zzYp;
    private long zzYG;
    private long zzYH;
    private final Value[] zzYI;
    private DataSource zzYJ;
    private long zzYK;
    private long zzYL;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zze();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.zzFG = versionCode;
        this.zzYp = dataSource;
        this.zzYJ = originalDataSource;
        this.zzYG = timestampNanos;
        this.zzYH = startTimeNanos;
        this.zzYI = values;
        this.zzYK = rawTimestamp;
        this.zzYL = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, zzxd.zzb rawDataPoint) {
        this(DataPoint.zzc(dataSources, rawDataPoint.zzaID), DataPoint.zzc(dataSources, rawDataPoint.zzaIF), rawDataPoint);
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(dataSources, zzmu.zzb(rawDataPoint));
    }

    public DataPoint(DataSource dataSource, DataSource originalDataSource, zzxd.zzb rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzaIA, 0L), DataPoint.zza(rawDataPoint.zzaIB, 0L), zzmx.zza(dataSource.zzly().zzaIf, rawDataPoint.zzaIC), originalDataSource, DataPoint.zza(rawDataPoint.zzaIH, 0L), DataPoint.zza(rawDataPoint.zzaII, 0L));
    }

    private static DataSource zzc(List<DataSource> list, int n) {
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.zzFG = 4;
        this.zzYp = (DataSource)zzx.zzb((Object)dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.zzYI = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzYI[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzc.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit timeUnit) {
        this.zzYG = timeUnit.toNanos(timestamp);
        if (this.zzlr() && zzmo.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzYG = zzmo.zza(this.zzYG, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean zzlr() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
        this.zzYH = timeUnit.toNanos(startTime);
        this.zzYG = timeUnit.toNanos(endTime);
        return this;
    }

    public Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzYI[n];
    }

    public Value[] zzls() {
        return this.zzYI;
    }

    public DataPoint setFloatValues(float ... values) {
        this.zzdi(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzYI[i].setFloat(values[i]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.zzdi(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzYI[i].setInt(values[i]);
        }
        return this;
    }

    private void zzdi(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzx.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public DataType getDataType() {
        return this.zzYp.getDataType();
    }

    public DataSource getDataSource() {
        return this.zzYp;
    }

    public DataSource getOriginalDataSource() {
        return this.zzYJ;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzYG, TimeUnit.NANOSECONDS);
    }

    public long zzlt() {
        return this.zzYK;
    }

    public long zzlu() {
        return this.zzYL;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzYH, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzYG, TimeUnit.NANOSECONDS);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DataPoint && this.zza((DataPoint)o);
    }

    private boolean zza(DataPoint dataPoint) {
        return zzw.equal((Object)this.zzYp, (Object)dataPoint.zzYp) && this.zzYG == dataPoint.zzYG && this.zzYH == dataPoint.zzYH && Arrays.equals(this.zzYI, dataPoint.zzYI) && zzw.equal((Object)this.zzYJ, (Object)dataPoint.zzYJ);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzYp, this.zzYG, this.zzYH});
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.zzYI), this.zzYH, this.zzYG, this.zzYK, this.zzYL, this.zzYp.toDebugString(), this.zzYJ != null ? this.zzYJ.toDebugString() : "N/A");
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    public long getTimestampNanos() {
        return this.zzYG;
    }

    public long zzlv() {
        return this.zzYH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zze.zza(this, parcel, flags);
    }

    private static long zza(Long l, long l2) {
        return l != null ? l : l2;
    }
}

