/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzd;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzms;
import com.google.android.gms.internal.zzmw;
import com.google.android.gms.internal.zzxd;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
implements SafeParcelable {
    public static final Comparator<Bucket> zzYB = new Comparator<Bucket>(){

        public int zza(Bucket bucket, Bucket bucket2) {
            long l = bucket.getStartTime(TimeUnit.MILLISECONDS);
            long l2 = bucket2.getStartTime(TimeUnit.MILLISECONDS);
            return zzmd.compare((long)l, (long)l2);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.zza((Bucket)x0, (Bucket)x1);
        }
    };
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int zzFG;
    private final long zzON;
    private final long zzYq;
    private final Session zzYs;
    private final int zzYC;
    private final List<DataSet> zzYD;
    private final int zzYE;
    private boolean zzYF = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zzd();

    Bucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activityType, List<DataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.zzFG = versionCode;
        this.zzON = startTimeMillis;
        this.zzYq = endTimeMillis;
        this.zzYs = session;
        this.zzYC = activityType;
        this.zzYD = dataSets;
        this.zzYE = bucketType;
        this.zzYF = serverHasMoreData;
    }

    public Bucket(RawBucket bucket, List<DataSource> uniqueDataSources) {
        this(zzms.zzb(bucket), uniqueDataSources);
    }

    public Bucket(zzxd.zza bucket, List<DataSource> uniqueDataSources) {
        this(2, bucket.zzaIq, bucket.zzaIr, bucket.zzaIt == null ? null : zzmw.zzZW.zza(bucket.zzaIt), bucket.zzaIu, Bucket.zza(bucket.zzaIv, uniqueDataSources), bucket.zzaIw, bucket.zzaIx);
    }

    private static List<DataSet> zza(zzxd.zzc[] zzcArray, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(zzcArray.length);
        for (zzxd.zzc zzc2 : zzcArray) {
            arrayList.add(new DataSet(zzc2, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzON, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzYq, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzYs;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzYC);
    }

    public int zzln() {
        return this.zzYC;
    }

    public List<DataSet> getDataSets() {
        return this.zzYD;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzYD) {
            if (!dataSet.getDataType().equals(dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzYE;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Bucket && this.zza((Bucket)o);
    }

    private boolean zza(Bucket bucket) {
        return this.zzON == bucket.zzON && this.zzYq == bucket.zzYq && this.zzYC == bucket.zzYC && zzw.equal(this.zzYD, bucket.zzYD) && this.zzYE == bucket.zzYE && this.zzYF == bucket.zzYF;
    }

    public boolean zzb(Bucket bucket) {
        return this.zzON == bucket.zzON && this.zzYq == bucket.zzYq && this.zzYC == bucket.zzYC && this.zzYE == bucket.zzYE;
    }

    public boolean zzlo() {
        if (this.zzYF) {
            return true;
        }
        for (DataSet dataSet : this.zzYD) {
            if (!dataSet.zzlo()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzON, this.zzYq, this.zzYC, this.zzYE});
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("startTime", (Object)this.zzON).zza("endTime", (Object)this.zzYq).zza("activity", (Object)this.zzYC).zza("dataSets", this.zzYD).zza("bucketType", (Object)Bucket.zzdg(this.zzYE)).zza("serverHasMoreData", (Object)this.zzYF).toString();
    }

    public static String zzdg(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public long zzlp() {
        return this.zzON;
    }

    public long zzlq() {
        return this.zzYq;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzd.zza(this, dest, flags);
    }
}

