/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.k;
import com.google.android.gms.fitness.service.SensorEventDispatcher;
import com.google.android.gms.fitness.service.a;
import com.google.android.gms.fitness.service.b;
import com.google.android.gms.internal.jv;
import java.util.concurrent.TimeUnit;

public class FitnessSensorServiceRequest
implements SafeParcelable {
    public static final int UNSPECIFIED = -1;
    private final int CK;
    private final DataSource TN;
    private final k VW;
    private final long Wy;
    private final long Wz;
    public static final Parcelable.Creator<FitnessSensorServiceRequest> CREATOR = new a();

    FitnessSensorServiceRequest(int versionCode, DataSource dataSource, IBinder listenerBinder, long samplingRateMicros, long batchIntervalMicros) {
        this.CK = versionCode;
        this.TN = dataSource;
        this.VW = k.a.aq(listenerBinder);
        this.Wy = samplingRateMicros;
        this.Wz = batchIntervalMicros;
    }

    public DataSource getDataSource() {
        return this.TN;
    }

    public SensorEventDispatcher getDispatcher() {
        return new b(this.VW);
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return this.Wy == -1L ? -1L : timeUnit.convert(this.Wy, TimeUnit.MICROSECONDS);
    }

    public long getBatchInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.Wz, TimeUnit.MICROSECONDS);
    }

    public String toString() {
        return String.format("FitnessSensorServiceRequest{%s}", this.TN);
    }

    int getVersionCode() {
        return this.CK;
    }

    IBinder kg() {
        return this.VW.asBinder();
    }

    public long jI() {
        return this.Wy;
    }

    public long kx() {
        return this.Wz;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        a.a(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FitnessSensorServiceRequest && this.a((FitnessSensorServiceRequest)that);
    }

    private boolean a(FitnessSensorServiceRequest fitnessSensorServiceRequest) {
        return jv.equal((Object)this.TN, (Object)fitnessSensorServiceRequest.TN) && this.Wy == fitnessSensorServiceRequest.Wy && this.Wz == fitnessSensorServiceRequest.Wz;
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.TN, this.Wy, this.Wz});
    }
}

