/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.b;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int CK;
    private final List<DataSet> Ua;
    private final Status Eb;
    private final List<Bucket> Wr;
    private int Ws;
    private final List<DataSource> Uk;
    private final List<DataType> Wt;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new b();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.CK = versionCode;
        this.Eb = status;
        this.Ws = batchCount;
        this.Uk = uniqueDataSources;
        this.Wt = uniqueDataTypes;
        this.Ua = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet object : dataSets) {
            this.Ua.add(new DataSet(object, uniqueDataSources, uniqueDataTypes));
        }
        this.Wr = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.Wr.add(new Bucket(rawBucket, uniqueDataSources, uniqueDataTypes));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.CK = 5;
        this.Ua = dataSets;
        this.Eb = status;
        this.Wr = buckets;
        this.Ws = 1;
        this.Uk = new ArrayList<DataSource>();
        this.Wt = new ArrayList<DataType>();
    }

    public static DataReadResult a(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource object : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(object));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.Ua) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataType.getName()));
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.Ua) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataSource.getStreamIdentifier()));
    }

    public List<DataSet> getDataSets() {
        return this.Ua;
    }

    public List<Bucket> getBuckets() {
        return this.Wr;
    }

    public int kr() {
        return this.Ws;
    }

    public void b(DataReadResult dataReadResult) {
        for (DataSet object : dataReadResult.getDataSets()) {
            this.a(object, this.Ua);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.a(bucket, this.Wr);
        }
    }

    private void a(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.a(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void a(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.b(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.a(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.Wr.add(bucket);
    }

    public Status getStatus() {
        return this.Eb;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.c((DataReadResult)that);
    }

    private boolean c(DataReadResult dataReadResult) {
        return this.Eb.equals((Object)dataReadResult.Eb) && jv.equal(this.Ua, dataReadResult.Ua) && jv.equal(this.Wr, dataReadResult.Wr);
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.Eb, this.Ua, this.Wr});
    }

    public String toString() {
        return jv.h((Object)this).a("status", (Object)this.Eb).a("dataSets", this.Ua.size() > 5 ? this.Ua.size() + " data sets" : this.Ua).a("buckets", this.Wr.size() > 5 ? this.Wr.size() + " buckets" : this.Wr).toString();
    }

    int getVersionCode() {
        return this.CK;
    }

    List<RawBucket> ks() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.Wr.size());
        for (Bucket bucket : this.Wr) {
            arrayList.add(new RawBucket(bucket, this.Uk, this.Wt));
        }
        return arrayList;
    }

    List<RawDataSet> kt() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.Ua.size());
        for (DataSet dataSet : this.Ua) {
            arrayList.add(new RawDataSet(dataSet, this.Uk, this.Wt));
        }
        return arrayList;
    }

    List<DataSource> jw() {
        return this.Uk;
    }

    List<DataType> ku() {
        return this.Wt;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        b.a(this, dest, flags);
    }
}

