/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.t;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
implements SafeParcelable {
    private final int CK;
    private final String Wj;
    private final String vZ;
    private final long LW;
    private final long TO;
    private final List<DataType> TY;
    private final List<DataSource> VH;
    private boolean Wk;
    private final boolean VR;
    private final List<String> Wl;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new t();

    SessionReadRequest(int versionCode, String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages) {
        this.CK = versionCode;
        this.Wj = sessionName;
        this.vZ = sessionId;
        this.LW = startTimeMillis;
        this.TO = endTimeMillis;
        this.TY = Collections.unmodifiableList(dataTypes);
        this.VH = Collections.unmodifiableList(dataSources);
        this.Wk = getSessionsFromAllApps;
        this.VR = serverQueriesEnabled;
        this.Wl = excludedPackages;
    }

    private SessionReadRequest(Builder builder) {
        this.CK = 3;
        this.Wj = builder.Wj;
        this.vZ = builder.vZ;
        this.LW = builder.LW;
        this.TO = builder.TO;
        this.TY = Collections.unmodifiableList(builder.TY);
        this.VH = Collections.unmodifiableList(builder.VH);
        this.Wk = builder.Wk;
        this.VR = builder.VR;
        this.Wl = Collections.unmodifiableList(builder.Wl);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.LW, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.TO, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.Wj;
    }

    public String getSessionId() {
        return this.vZ;
    }

    public List<DataType> getDataTypes() {
        return this.TY;
    }

    public List<DataSource> getDataSources() {
        return this.VH;
    }

    public boolean includeSessionsFromAllApps() {
        return this.Wk;
    }

    public List<String> getExcludedPackages() {
        return this.Wl;
    }

    public boolean jV() {
        return this.VR;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof SessionReadRequest && this.a((SessionReadRequest)o2);
    }

    private boolean a(SessionReadRequest sessionReadRequest) {
        return jv.equal((Object)this.Wj, (Object)sessionReadRequest.Wj) && this.vZ.equals(sessionReadRequest.vZ) && this.LW == sessionReadRequest.LW && this.TO == sessionReadRequest.TO && jv.equal(this.TY, sessionReadRequest.TY) && jv.equal(this.VH, sessionReadRequest.VH) && this.Wk == sessionReadRequest.Wk && this.Wl.equals(sessionReadRequest.Wl) && this.VR == sessionReadRequest.VR;
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.Wj, this.vZ, this.LW, this.TO});
    }

    public String toString() {
        return jv.h((Object)this).a("sessionName", (Object)this.Wj).a("sessionId", (Object)this.vZ).a("startTimeMillis", (Object)this.LW).a("endTimeMillis", (Object)this.TO).a("dataTypes", this.TY).a("dataSources", this.VH).a("sessionsFromAllApps", (Object)this.Wk).a("excludedPackages", this.Wl).a("useServer", (Object)this.VR).toString();
    }

    public long jp() {
        return this.TO;
    }

    public long jo() {
        return this.LW;
    }

    public boolean kj() {
        return this.Wk;
    }

    int getVersionCode() {
        return this.CK;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        t.a(this, dest, flags);
    }

    public static class Builder {
        private String Wj;
        private String vZ;
        private long LW = 0L;
        private long TO = 0L;
        private List<DataType> TY = new ArrayList<DataType>();
        private List<DataSource> VH = new ArrayList<DataSource>();
        private boolean Wk = false;
        private boolean VR = false;
        private List<String> Wl = new ArrayList<String>();

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            this.LW = timeUnit.toMillis(startTime);
            this.TO = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder setSessionName(String sessionName) {
            this.Wj = sessionName;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.vZ = sessionId;
            return this;
        }

        public Builder read(DataSource dataSource) {
            jx.b((Object)dataSource, (Object)"Attempting to add a null data source");
            if (!this.VH.contains(dataSource)) {
                this.VH.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            jx.b((Object)dataType, (Object)"Attempting to use a null data type");
            if (!this.TY.contains(dataType)) {
                this.TY.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.Wk = true;
            return this;
        }

        public Builder excludePackage(String appPackageName) {
            jx.b((Object)appPackageName, (Object)"Attempting to use a null package name");
            if (!this.Wl.contains(appPackageName)) {
                this.Wl.add(appPackageName);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.VR = true;
            return this;
        }

        public SessionReadRequest build() {
            jx.b((this.LW > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.LW});
            jx.b((this.TO > 0L && this.TO > this.LW ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.TO});
            return new SessionReadRequest(this);
        }
    }
}

