/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.s;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.lt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int CK;
    private final Session TQ;
    private final List<DataSet> Ua;
    private final List<DataPoint> Wh;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new s();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints) {
        this.CK = versionCode;
        this.TQ = session;
        this.Ua = Collections.unmodifiableList(dataSets);
        this.Wh = Collections.unmodifiableList(aggregateDataPoints);
    }

    private SessionInsertRequest(Builder builder) {
        this.CK = 1;
        this.TQ = builder.TQ;
        this.Ua = Collections.unmodifiableList(builder.Ua);
        this.Wh = Collections.unmodifiableList(builder.Wh);
    }

    public Session getSession() {
        return this.TQ;
    }

    public List<DataSet> getDataSets() {
        return this.Ua;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.Wh;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof SessionInsertRequest && this.a((SessionInsertRequest)o2);
    }

    private boolean a(SessionInsertRequest sessionInsertRequest) {
        return jv.equal((Object)this.TQ, (Object)sessionInsertRequest.TQ) && jv.equal(this.Ua, sessionInsertRequest.Ua) && jv.equal(this.Wh, sessionInsertRequest.Wh);
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.TQ, this.Ua, this.Wh});
    }

    public String toString() {
        return jv.h((Object)this).a("session", (Object)this.TQ).a("dataSets", this.Ua).a("aggregateDataPoints", this.Wh).toString();
    }

    int getVersionCode() {
        return this.CK;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        s.a(this, dest, flags);
    }

    public static class Builder {
        private Session TQ;
        private List<DataSet> Ua = new ArrayList<DataSet>();
        private List<DataPoint> Wh = new ArrayList<DataPoint>();
        private List<DataSource> Wi = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.TQ = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            jx.b((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            jx.a((!this.Wi.contains(dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            List<DataPoint> list = dataSet.getDataPoints();
            jx.b((!list.isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.Wi.add(dataSource);
            this.Ua.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            jx.b((aggregateDataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            long l2 = aggregateDataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = aggregateDataPoint.getEndTime(TimeUnit.NANOSECONDS);
            jx.b((l2 > 0L && l3 > l2 ? 1 : 0) != 0, (String)"Aggregate data point should have valid start and end times: %s", (Object[])new Object[]{aggregateDataPoint});
            DataSource dataSource = aggregateDataPoint.getDataSource();
            jx.a((!this.Wi.contains(dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            this.Wi.add(dataSource);
            this.Wh.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            jx.a((this.TQ != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            jx.a((this.TQ.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.ki();
            return new SessionInsertRequest(this);
        }

        private void d(DataPoint dataPoint) {
            this.f(dataPoint);
            this.e(dataPoint);
        }

        private void e(DataPoint dataPoint) {
            long l2 = this.TQ.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = this.TQ.getEndTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l5 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l4 != 0L && l5 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l5 > l3) {
                    l5 = lt.a(l5, TimeUnit.NANOSECONDS, timeUnit);
                }
                jx.a((l4 >= l2 && l5 <= l3 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l2, l3});
                if (l5 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l5, timeUnit}));
                    dataPoint.setTimeInterval(l4, l5, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void f(DataPoint dataPoint) {
            long l2 = this.TQ.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = this.TQ.getEndTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 < l2 || l4 > l3) {
                    l4 = lt.a(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                jx.a((l4 >= l2 && l4 <= l3 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l2, l3});
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l4) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimestamp(l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void ki() {
            for (DataSet object : this.Ua) {
                for (DataPoint dataPoint : object.getDataPoints()) {
                    this.d(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.Wh) {
                this.d(dataPoint);
            }
        }
    }
}

