/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.i;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
implements SafeParcelable {
    private final int CK;
    private final String mName;
    private final List<Field> Uv;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new i();

    DataTypeCreateRequest(int versionCode, String name, List<Field> fields) {
        this.CK = versionCode;
        this.mName = name;
        this.Uv = Collections.unmodifiableList(fields);
    }

    private DataTypeCreateRequest(Builder builder) {
        this.CK = 1;
        this.mName = builder.mName;
        this.Uv = Collections.unmodifiableList(builder.Uv);
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.Uv;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataTypeCreateRequest && this.a((DataTypeCreateRequest)o2);
    }

    private boolean a(DataTypeCreateRequest dataTypeCreateRequest) {
        return jv.equal((Object)this.mName, (Object)dataTypeCreateRequest.mName) && jv.equal(this.Uv, dataTypeCreateRequest.Uv);
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.mName, this.Uv});
    }

    public String toString() {
        return jv.h((Object)this).a("name", (Object)this.mName).a("fields", this.Uv).toString();
    }

    int getVersionCode() {
        return this.CK;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        i.a(this, dest, flags);
    }

    public static class Builder {
        private String mName;
        private List<Field> Uv = new ArrayList<Field>();

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.Uv.contains(field)) {
                this.Uv.add(field);
            }
            return this;
        }

        public Builder addField(String name, int format) {
            jx.b((name != null || !name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid name specified");
            Field field = new Field(name, format);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            jx.a((this.mName != null ? 1 : 0) != 0, (Object)"Must set the name");
            jx.a((!this.Uv.isEmpty() ? 1 : 0) != 0, (Object)"Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

