/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.g;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int CK;
    private final List<DataType> TY;
    private final List<DataSource> VH;
    private final long LW;
    private final long TO;
    private final List<DataType> VL;
    private final List<DataSource> VM;
    private final int Ub;
    private final long VN;
    private final DataSource VO;
    private final int VP;
    private final boolean VQ;
    private final boolean VR;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new g();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled) {
        this.CK = versionCode;
        this.TY = Collections.unmodifiableList(dataTypes);
        this.VH = Collections.unmodifiableList(dataSources);
        this.LW = startTimeMillis;
        this.TO = endTimeMillis;
        this.VL = Collections.unmodifiableList(aggregatedDataTypes);
        this.VM = Collections.unmodifiableList(aggregatedDataSources);
        this.Ub = bucketType;
        this.VN = bucketDurationMillis;
        this.VO = activityDataSource;
        this.VP = limit;
        this.VQ = flushBeforeRead;
        this.VR = serverQueriesEnabled;
    }

    private DataReadRequest(Builder builder) {
        this.CK = 2;
        this.TY = Collections.unmodifiableList(builder.TY);
        this.VH = Collections.unmodifiableList(builder.VH);
        this.LW = builder.LW;
        this.TO = builder.TO;
        this.VL = Collections.unmodifiableList(builder.VL);
        this.VM = Collections.unmodifiableList(builder.VM);
        this.Ub = builder.Ub;
        this.VN = builder.VN;
        this.VO = builder.VO;
        this.VP = builder.VP;
        this.VQ = builder.VQ;
        this.VR = builder.VR;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.LW, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.TO, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.TY;
    }

    public List<DataSource> getDataSources() {
        return this.VH;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.VL;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.VM;
    }

    public int getBucketType() {
        return this.Ub;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.VN, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.VO;
    }

    public int getLimit() {
        return this.VP;
    }

    public boolean jV() {
        return this.VR;
    }

    public boolean jW() {
        return this.VQ;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.a((DataReadRequest)that);
    }

    private boolean a(DataReadRequest dataReadRequest) {
        return this.TY.equals(dataReadRequest.TY) && this.VH.equals(dataReadRequest.VH) && this.LW == dataReadRequest.LW && this.TO == dataReadRequest.TO && this.Ub == dataReadRequest.Ub && this.VM.equals(dataReadRequest.VM) && this.VL.equals(dataReadRequest.VL) && jv.equal((Object)this.VO, (Object)dataReadRequest.VO) && this.VN == dataReadRequest.VN && this.VR == dataReadRequest.VR;
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.Ub, this.LW, this.TO});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.TY.isEmpty()) {
            for (DataType object : this.TY) {
                stringBuilder.append(object.jB()).append(" ");
            }
        }
        if (!this.VH.isEmpty()) {
            for (DataSource dataSource : this.VH) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.Ub != 0) {
            stringBuilder.append("bucket by ").append(Bucket.cJ(this.Ub));
            if (this.VN > 0L) {
                stringBuilder.append(" >").append(this.VN).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.VL.isEmpty()) {
            for (DataType dataType : this.VL) {
                stringBuilder.append(dataType.jB()).append(" ");
            }
        }
        if (!this.VM.isEmpty()) {
            for (DataSource dataSource : this.VM) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.LW, this.LW, this.TO, this.TO));
        if (this.VO != null) {
            stringBuilder.append("activities: ").append(this.VO.toDebugString());
        }
        if (this.VR) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.CK;
    }

    public long jp() {
        return this.TO;
    }

    public long jo() {
        return this.LW;
    }

    public long jX() {
        return this.VN;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        g.a(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> TY = new ArrayList<DataType>();
        private List<DataSource> VH = new ArrayList<DataSource>();
        private List<DataType> VL = new ArrayList<DataType>();
        private List<DataSource> VM = new ArrayList<DataSource>();
        private DataSource VO;
        private long LW;
        private long TO;
        private int Ub = 0;
        private long VN = 0L;
        private int VP = 0;
        private boolean VQ = false;
        private boolean VR = false;

        public Builder read(DataSource dataSource) {
            jx.b((Object)dataSource, (Object)"Attempting to add a null data source");
            jx.b((!this.VM.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.VH.contains(dataSource)) {
                this.VH.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            jx.b((Object)dataType, (Object)"Attempting to use a null data type");
            jx.a((!this.VL.contains(dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.TY.contains(dataType)) {
                this.TY.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            jx.b((Object)dataSource, (Object)"Attempting to add a null data source");
            jx.a((!this.VH.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            jx.b((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(dataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            jx.b((boolean)DataType.getAggregatesForInput(dataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, outputDataType});
            if (!this.VM.contains(dataSource)) {
                this.VM.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            jx.b((Object)inputDataType, (Object)"Attempting to use a null data type");
            jx.a((!this.TY.contains(inputDataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            jx.b((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(inputDataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{inputDataType});
            jx.b((boolean)DataType.getAggregatesForInput(inputDataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{inputDataType, outputDataType});
            if (!this.VL.contains(inputDataType)) {
                this.VL.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            jx.b((this.Ub == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Ub});
            jx.b((duration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{duration});
            this.Ub = 1;
            this.VN = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            jx.b((this.Ub == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Ub});
            jx.b((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.Ub = 3;
            this.VN = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            jx.b((this.Ub == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Ub});
            jx.b((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            jx.b((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            jx.b((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.VO = activityDataSource;
            this.Ub = 3;
            this.VN = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            jx.b((this.Ub == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Ub});
            jx.b((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.Ub = 4;
            this.VN = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            jx.b((this.Ub == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Ub});
            jx.b((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            jx.b((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            jx.b((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.VO = activityDataSource;
            this.Ub = 4;
            this.VN = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            jx.b((this.Ub == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.Ub});
            jx.b((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.Ub = 2;
            this.VN = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long start, long end, TimeUnit timeUnit) {
            this.LW = timeUnit.toMillis(start);
            this.TO = timeUnit.toMillis(end);
            return this;
        }

        public Builder enableServerQueries() {
            this.VR = true;
            return this;
        }

        public Builder setLimit(int limit) {
            jx.b((limit > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{limit});
            this.VP = limit;
            return this;
        }

        public DataReadRequest build() {
            jx.a((!this.VH.isEmpty() || !this.TY.isEmpty() || !this.VM.isEmpty() || !this.VL.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            jx.a((this.LW > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.LW});
            jx.a((this.TO > 0L && this.TO > this.LW ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.TO});
            boolean bl = this.VM.isEmpty() && this.VL.isEmpty();
            jx.a((bl && this.Ub == 0 || !bl && this.Ub != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

