/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.u;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;

public final class Value
implements SafeParcelable {
    private final int CK;
    private final int UE;
    private boolean US;
    private float UT;
    public static final Parcelable.Creator<Value> CREATOR = new u();

    Value(int format) {
        this(1, format, false, 0.0f);
    }

    Value(int versionCode, int format, boolean isSet, float value) {
        this.CK = versionCode;
        this.UE = format;
        this.US = isSet;
        this.UT = value;
    }

    public void setInt(int value) {
        jx.a((this.UE == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.US = true;
        this.UT = Float.intBitsToFloat(value);
    }

    public void setFloat(float value) {
        jx.a((this.UE == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.US = true;
        this.UT = value;
    }

    public void setActivity(String activity) {
        this.setInt(FitnessActivities.bs(activity));
    }

    public boolean isSet() {
        return this.US;
    }

    public int getFormat() {
        return this.UE;
    }

    public int asInt() {
        jx.a((this.UE == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.UT);
    }

    public float asFloat() {
        jx.a((this.UE == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.UT;
    }

    public String asActivity() {
        try {
            return FitnessActivities.getName(this.asInt());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "unknown";
        }
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof Value && this.a((Value)o2);
    }

    private boolean a(Value value) {
        if (this.UE == value.UE && this.US == value.US) {
            switch (this.UE) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.asFloat() == value.asFloat();
                }
            }
            return this.UT == value.UT;
        }
        return false;
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{Float.valueOf(this.UT), this.UE, this.US});
    }

    public String toString() {
        if (!this.US) {
            return "unset";
        }
        switch (this.UE) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.asFloat());
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.CK;
    }

    float jL() {
        return this.UT;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        u.a(this, dest, flags);
    }
}

