/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.a;
import com.google.android.gms.fitness.data.g;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.mg;

public class DataSource
implements SafeParcelable {
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int CK;
    private final DataType TM;
    private final String mName;
    private final int Gt;
    private final Device Ul;
    private final a Um;
    private final String Un;
    private final boolean Uo;
    private final String Up;
    public static final Parcelable.Creator<DataSource> CREATOR = new g();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, a application, String streamName, boolean isObfuscated) {
        this.CK = versionCode;
        this.TM = dataType;
        this.Gt = type;
        this.mName = name;
        this.Ul = device;
        this.Um = application;
        this.Un = streamName;
        this.Uo = isObfuscated;
        this.Up = this.jy();
    }

    private DataSource(Builder builder) {
        this.CK = 3;
        this.TM = builder.TM;
        this.Gt = builder.Gt;
        this.mName = builder.mName;
        this.Ul = builder.Ul;
        this.Um = builder.Um;
        this.Un = builder.Un;
        this.Uo = builder.Uo;
        this.Up = this.jy();
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)c.a((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.TM;
    }

    public int getType() {
        return this.Gt;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.Um == null ? null : this.Um.getPackageName();
    }

    public a jx() {
        return this.Um;
    }

    public Device getDevice() {
        return this.Ul;
    }

    public String getStreamName() {
        return this.Un;
    }

    public String getStreamIdentifier() {
        return this.Up;
    }

    private String jy() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.TM.getName());
        if (this.Um != null) {
            stringBuilder.append(":").append(this.Um.getPackageName());
        }
        if (this.Ul != null) {
            stringBuilder.append(":").append(this.Ul.getStreamIdentifier());
        }
        if (this.Un != null) {
            stringBuilder.append(":").append(this.Un);
        }
        return stringBuilder.toString();
    }

    public boolean jz() {
        return this.Uo;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.a((DataSource)that);
    }

    private boolean a(DataSource dataSource) {
        return this.Up.equals(dataSource.Up);
    }

    public int hashCode() {
        return this.Up.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.Um != null) {
            stringBuilder.append(":").append(this.Um);
        }
        if (this.Ul != null) {
            stringBuilder.append(":").append(this.Ul);
        }
        if (this.Un != null) {
            stringBuilder.append(":").append(this.Un);
        }
        stringBuilder.append(":").append(this.TM);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.Gt == 0 ? "r" : "d") + ":" + this.TM.jB() + (this.Um == null ? "" : (this.Um.equals(a.TT) ? ":gms" : ":" + this.Um.getPackageName())) + (this.Ul != null ? ":" + this.Ul.getModel() + ":" + this.Ul.getUid() : "") + (this.Un != null ? ":" + this.Un : "");
    }

    private String getTypeString() {
        switch (this.Gt) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    public DataSource jA() {
        Device device = this.Ul == null ? null : this.Ul.jE();
        a a2 = this.Um == null ? null : this.Um.jl();
        return new DataSource(3, this.TM, this.mName, this.Gt, device, a2, mg.bw(this.Un), this.Uo);
    }

    int getVersionCode() {
        return this.CK;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        DataSource dataSource = mg.c(this);
        g.a(dataSource, parcel, flags);
    }

    public static final class Builder {
        private DataType TM;
        private int Gt = -1;
        private String mName;
        private Device Ul;
        private a Um;
        private String Un = "";
        private boolean Uo = false;

        public Builder setDataType(DataType dataType) {
            this.TM = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.Gt = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.Ul = device;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.Um = new a(packageName, null, null);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            jx.b((streamName != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.Un = streamName;
            return this;
        }

        public Builder setObfuscated(boolean isObfuscated) {
            this.Uo = isObfuscated;
            return this;
        }

        public DataSource build() {
            jx.a((this.TM != null ? 1 : 0) != 0, (Object)"Must set data type");
            jx.a((this.Gt >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

