/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.f;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataSet
implements SafeParcelable {
    private final int CK;
    private final DataSource TN;
    private final DataType TM;
    private final List<DataPoint> Uj;
    private final List<DataSource> Uk;
    private boolean Uc = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new f();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.CK = versionCode;
        this.TN = dataSource;
        this.TM = dataType;
        this.Uc = serverHasMoreData;
        this.Uj = new ArrayList<DataPoint>(dataPoints.size());
        this.Uk = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.Uj.add(new DataPoint(this.Uk, rawDataPoint));
        }
    }

    private DataSet(DataSource dataSource, DataType dataType) {
        this.CK = 3;
        this.TN = (DataSource)jx.i((Object)dataSource);
        this.TM = (DataType)jx.i((Object)dataType);
        this.Uj = new ArrayList<DataPoint>();
        this.Uk = new ArrayList<DataSource>();
        this.Uk.add(this.TN);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this(3, DataSet.d(uniqueDataSources, dataSet.UJ), DataSet.d(uniqueDataTypes, dataSet.UL), dataSet.UM, uniqueDataSources, dataSet.Uc);
    }

    private static <T> T d(List<T> list, int n2) {
        return n2 >= 0 && n2 < list.size() ? (T)list.get(n2) : null;
    }

    public static DataSet create(DataSource dataSource) {
        jx.b((Object)dataSource, (Object)"DataSource should be specified");
        return new DataSet(dataSource, dataSource.getDataType());
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.TN);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        jx.b((boolean)dataSource.getStreamIdentifier().equals(this.TN.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.TN});
        jx.b((boolean)dataPoint.getDataType().getName().equals(this.TM.getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{dataPoint.getDataType(), this.TM});
        jx.b((dataPoint.getTimestamp(TimeUnit.NANOSECONDS) > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{dataPoint});
        jx.b((dataPoint.getStartTime(TimeUnit.NANOSECONDS) <= dataPoint.getEndTime(TimeUnit.NANOSECONDS) ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{dataPoint});
        this.b(dataPoint);
    }

    public void b(DataPoint dataPoint) {
        this.Uj.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.Uk.contains(dataSource)) {
            this.Uk.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void a(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.b(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.TN;
    }

    public DataType getDataType() {
        return this.TM;
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.Uj);
    }

    public boolean jn() {
        return this.Uc;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataSet && this.a((DataSet)o2);
    }

    private boolean a(DataSet dataSet) {
        return jv.equal((Object)this.TM, (Object)dataSet.TM) && jv.equal((Object)this.TN, (Object)dataSet.TN) && jv.equal(this.Uj, dataSet.Uj) && this.Uc == dataSet.Uc;
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.TM, this.TN});
    }

    public String toString() {
        List<RawDataPoint> list = this.jv();
        return String.format("DataSet{%s %s}", this.TN.toDebugString(), this.Uj.size() < 10 ? list : String.format("%d data points, first 5: %s", this.Uj.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.CK;
    }

    List<RawDataPoint> jv() {
        return this.f(this.Uk);
    }

    List<RawDataPoint> f(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.Uj.size());
        for (DataPoint dataPoint : this.Uj) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> jw() {
        return this.Uk;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        f.a(this, parcel, flags);
    }
}

