/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.e;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.lt;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int CK;
    private final DataSource TN;
    private long Ud;
    private long Ue;
    private final Value[] Uf;
    private DataSource Ug;
    private long Uh;
    private long Ui;
    public static final Parcelable.Creator<DataPoint> CREATOR = new e();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.CK = versionCode;
        this.TN = dataSource;
        this.Ug = originalDataSource;
        this.Ud = timestampNanos;
        this.Ue = startTimeNanos;
        this.Uf = values;
        this.Uh = rawTimestamp;
        this.Ui = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(4, DataPoint.c(dataSources, rawDataPoint.UJ), rawDataPoint.Ud, rawDataPoint.Ue, rawDataPoint.Uf, DataPoint.c(dataSources, rawDataPoint.UK), rawDataPoint.Uh, rawDataPoint.Ui);
    }

    private static DataSource c(List<DataSource> list, int n2) {
        return n2 >= 0 && n2 < list.size() ? list.get(n2) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.CK = 4;
        this.TN = (DataSource)jx.b((Object)dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.Uf = new Value[list.size()];
        int n2 = 0;
        for (Field field : list) {
            this.Uf[n2] = new Value(field.getFormat());
            ++n2;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)c.a((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit timeUnit) {
        this.Ud = timeUnit.toNanos(timestamp);
        if (this.jq() && lt.a(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.Ud = lt.a(this.Ud, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean jq() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
        this.Ue = timeUnit.toNanos(startTime);
        this.Ud = timeUnit.toNanos(endTime);
        return this;
    }

    public Value getValue(Field field) {
        int n2 = this.getDataType().indexOf(field);
        return this.Uf[n2];
    }

    public Value[] jr() {
        return this.Uf;
    }

    public DataPoint setFloatValues(float ... values) {
        this.cL(values.length);
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.Uf[i2].setFloat(values[i2]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.cL(values.length);
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.Uf[i2].setInt(values[i2]);
        }
        return this;
    }

    private void cL(int n2) {
        List<Field> list = this.getDataType().getFields();
        int n3 = list.size();
        jx.b((n2 == n3 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n2, n3, list});
    }

    public DataType getDataType() {
        return this.TN.getDataType();
    }

    public DataSource getDataSource() {
        return this.TN;
    }

    public DataSource getOriginalDataSource() {
        return this.Ug;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.Ud, TimeUnit.NANOSECONDS);
    }

    public long js() {
        return this.Uh;
    }

    public long jt() {
        return this.Ui;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.Ue, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.Ud, TimeUnit.NANOSECONDS);
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof DataPoint && this.a((DataPoint)o2);
    }

    private boolean a(DataPoint dataPoint) {
        return jv.equal((Object)this.TN, (Object)dataPoint.TN) && this.Ud == dataPoint.Ud && this.Ue == dataPoint.Ue && Arrays.equals(this.Uf, dataPoint.Uf) && jv.equal((Object)this.Ug, (Object)dataPoint.Ug);
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.TN, this.Ud, this.Ue});
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.Uf), this.Ue, this.Ud, this.Uh, this.Ui, this.TN, this.Ug);
    }

    public int getVersionCode() {
        return this.CK;
    }

    public long getTimestampNanos() {
        return this.Ud;
    }

    public long ju() {
        return this.Ue;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        e.a(this, parcel, flags);
    }
}

