/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.d;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
implements SafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int CK;
    private final long LW;
    private final long TO;
    private final Session TQ;
    private final int TZ;
    private final List<DataSet> Ua;
    private final int Ub;
    private boolean Uc = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new d();

    Bucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activityType, List<DataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.CK = versionCode;
        this.LW = startTimeMillis;
        this.TO = endTimeMillis;
        this.TQ = session;
        this.TZ = activityType;
        this.Ua = dataSets;
        this.Ub = bucketType;
        this.Uc = serverHasMoreData;
    }

    public Bucket(RawBucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this(2, bucket.LW, bucket.TO, bucket.TQ, bucket.UI, Bucket.a(bucket.Ua, uniqueDataSources, uniqueDataTypes), bucket.Ub, bucket.Uc);
    }

    private static List<DataSet> a(List<RawDataSet> list, List<DataSource> list2, List<DataType> list3) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(list.size());
        for (RawDataSet rawDataSet : list) {
            arrayList.add(new DataSet(rawDataSet, list2, list3));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.LW, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.TO, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.TQ;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.TZ);
    }

    public int jm() {
        return this.TZ;
    }

    public List<DataSet> getDataSets() {
        return this.Ua;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.Ua) {
            if (!dataSet.getDataType().equals(dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.Ub;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof Bucket && this.a((Bucket)o2);
    }

    private boolean a(Bucket bucket) {
        return this.LW == bucket.LW && this.TO == bucket.TO && this.TZ == bucket.TZ && jv.equal(this.Ua, bucket.Ua) && this.Ub == bucket.Ub && this.Uc == bucket.Uc;
    }

    public boolean b(Bucket bucket) {
        return this.LW == bucket.LW && this.TO == bucket.TO && this.TZ == bucket.TZ && this.Ub == bucket.Ub;
    }

    public boolean jn() {
        if (this.Uc) {
            return true;
        }
        for (DataSet dataSet : this.Ua) {
            if (!dataSet.jn()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.LW, this.TO, this.TZ, this.Ub});
    }

    public String toString() {
        return jv.h((Object)this).a("startTime", (Object)this.LW).a("endTime", (Object)this.TO).a("activity", (Object)this.TZ).a("dataSets", this.Ua).a("bucketType", (Object)Bucket.cJ(this.Ub)).a("serverHasMoreData", (Object)this.Uc).toString();
    }

    public static String cJ(int n2) {
        switch (n2) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.CK;
    }

    public long jo() {
        return this.LW;
    }

    public long jp() {
        return this.TO;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        d.a(this, dest, flags);
    }
}

