/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.zzj;
import com.google.android.gms.drive.internal.zzt;

public class CreateFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private final zzj zzacV = new zzj(0);
    private DriveContents zzacW;
    private boolean zzacX;

    public CreateFileActivityBuilder setInitialDriveContents(DriveContents driveContents) {
        if (driveContents != null) {
            if (!(driveContents instanceof zzt)) {
                throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            }
            if (driveContents.getDriveId() != null) {
                throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            }
            if (driveContents.zzpg()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
            this.zzacV.zzct(driveContents.zzpe().getRequestId());
            this.zzacW = driveContents;
        } else {
            this.zzacV.zzct(1);
        }
        this.zzacX = true;
        return this;
    }

    public CreateFileActivityBuilder setInitialMetadata(MetadataChangeSet metadataChangeSet) {
        this.zzacV.zza(metadataChangeSet);
        return this;
    }

    public CreateFileActivityBuilder setActivityStartFolder(DriveId folder) {
        this.zzacV.zza(folder);
        return this;
    }

    public CreateFileActivityBuilder setActivityTitle(String title) {
        this.zzacV.zzcv(title);
        return this;
    }

    public IntentSender build(GoogleApiClient apiClient) {
        zzu.zzb((Object)this.zzacX, (Object)"Must call setInitialDriveContents to CreateFileActivityBuilder.");
        zzu.zza((boolean)apiClient.isConnected(), (Object)"Client must be connected");
        zzu.zzb((apiClient.zza(Drive.SCOPE_FILE) || apiClient.zza(Drive.zzacY) ? 1 : 0) != 0, (Object)"The apiClient must have suitable scope to create files");
        if (this.zzacW != null) {
            this.zzacW.zzpf();
        }
        return this.zzacV.build(apiClient);
    }
}

