/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.ListParentsRequest;
import com.google.android.gms.drive.internal.OnListParentsResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.SetResourceParentsRequest;
import com.google.android.gms.drive.internal.UpdateMetadataRequest;
import com.google.android.gms.drive.internal.af;
import com.google.android.gms.drive.internal.bg;
import com.google.android.gms.drive.internal.m;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.q;
import com.google.android.gms.drive.internal.r;
import java.util.ArrayList;
import java.util.Set;

public class y
implements DriveResource {
    protected final DriveId Oj;

    protected y(DriveId driveId) {
        this.Oj = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.Oj;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient apiClient) {
        return apiClient.a((BaseImplementation.a)new d(apiClient){

            protected void a(r r2) throws RemoteException {
                r2.iG().a(new GetMetadataRequest(y.this.Oj), (af)new b((BaseImplementation.b<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient apiClient) {
        return apiClient.a((BaseImplementation.a)new p.g(apiClient){

            protected void a(r r2) throws RemoteException {
                r2.iG().a(new ListParentsRequest(y.this.Oj), (af)new a((BaseImplementation.b<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient apiClient, Set<DriveId> parentIds) {
        if (parentIds == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        if (parentIds.isEmpty()) {
            throw new IllegalArgumentException("ParentIds must contain at least one parent.");
        }
        final ArrayList<DriveId> arrayList = new ArrayList<DriveId>(parentIds);
        return apiClient.b((BaseImplementation.a)new q.a(apiClient){

            protected void a(r r2) throws RemoteException {
                r2.iG().a(new SetResourceParentsRequest(y.this.Oj, arrayList), (af)new bg((BaseImplementation.b<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return apiClient.b((BaseImplementation.a)new d(apiClient){

            protected void a(r r2) throws RemoteException {
                changeSet.iz().setContext(r2.getContext());
                r2.iG().a(new UpdateMetadataRequest(y.this.Oj, changeSet.iz()), (af)new b((BaseImplementation.b<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        r r2 = (r)apiClient.a(Drive.DQ);
        return r2.a(apiClient, this.Oj, 1, listener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        r r2 = (r)apiClient.a(Drive.DQ);
        return r2.b(apiClient, this.Oj, 1, listener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient apiClient) {
        r r2 = (r)apiClient.a(Drive.DQ);
        return r2.a(apiClient, this.Oj, 1);
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient apiClient) {
        r r2 = (r)apiClient.a(Drive.DQ);
        return r2.b(apiClient, this.Oj, 1);
    }

    private static class a
    extends com.google.android.gms.drive.internal.c {
        private final BaseImplementation.b<DriveApi.MetadataBufferResult> Ea;

        public a(BaseImplementation.b<DriveApi.MetadataBufferResult> b2) {
            this.Ea = b2;
        }

        @Override
        public void a(OnListParentsResponse onListParentsResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListParentsResponse.iT(), null);
            this.Ea.b((Object)new p.f(Status.Kw, metadataBuffer, false));
        }

        @Override
        public void n(Status status) throws RemoteException {
            this.Ea.b((Object)new p.f(status, null, false));
        }
    }

    private static class b
    extends com.google.android.gms.drive.internal.c {
        private final BaseImplementation.b<DriveResource.MetadataResult> Ea;

        public b(BaseImplementation.b<DriveResource.MetadataResult> b2) {
            this.Ea = b2;
        }

        @Override
        public void a(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.Ea.b((Object)new c(Status.Kw, new m(onMetadataResponse.iU())));
        }

        @Override
        public void n(Status status) throws RemoteException {
            this.Ea.b((Object)new c(status, null));
        }
    }

    private static class c
    implements DriveResource.MetadataResult {
        private final Status Eb;
        private final Metadata Qv;

        public c(Status status, Metadata metadata) {
            this.Eb = status;
            this.Qv = metadata;
        }

        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public Metadata getMetadata() {
            return this.Qv;
        }
    }

    private abstract class d
    extends q<DriveResource.MetadataResult> {
        private d(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveResource.MetadataResult u(Status status) {
            return new c(status, null);
        }

        public /* synthetic */ Result c(Status status) {
            return this.u(status);
        }
    }
}

