/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.af;
import com.google.android.gms.drive.internal.bg;
import com.google.android.gms.drive.internal.m;
import com.google.android.gms.drive.internal.q;
import com.google.android.gms.drive.internal.r;
import com.google.android.gms.drive.internal.s;
import com.google.android.gms.drive.internal.t;
import com.google.android.gms.drive.internal.v;
import com.google.android.gms.drive.query.Query;
import java.util.List;

public class p
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient apiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return apiClient.a((BaseImplementation.a)new g(apiClient){

            protected void a(r r2) throws RemoteException {
                r2.iG().a(new QueryRequest(query), (af)new i((BaseImplementation.b<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> newDriveContents(GoogleApiClient apiClient) {
        return this.a(apiClient, 0x20000000);
    }

    public PendingResult<DriveApi.DriveContentsResult> a(GoogleApiClient googleApiClient, final int n2) {
        return googleApiClient.a((BaseImplementation.a)new b(googleApiClient){

            protected void a(r r2) throws RemoteException {
                r2.iG().a(new CreateContentsRequest(n2), (af)new h((BaseImplementation.b<DriveApi.DriveContentsResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient apiClient, final String resourceId) {
        return apiClient.a((BaseImplementation.a)new e(apiClient){

            protected void a(r r2) throws RemoteException {
                r2.iG().a(new GetMetadataRequest(DriveId.bi(resourceId)), (af)new c((BaseImplementation.b<DriveApi.DriveIdResult>)this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new t(driveId);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new v(driveId);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        r r2 = (r)apiClient.a(Drive.DQ);
        return new v(r2.iH());
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        r r2 = (r)apiClient.a(Drive.DQ);
        DriveId driveId = r2.iI();
        return driveId != null ? new v(driveId) : null;
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient apiClient) {
        return apiClient.b((BaseImplementation.a)new q.a(apiClient){

            protected void a(r r2) throws RemoteException {
                r2.iG().a(new bg((BaseImplementation.b<Status>)this));
            }
        });
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, List<String> trackingTags) {
        r r2 = (r)apiClient.a(Drive.DQ);
        return r2.cancelPendingActions(apiClient, trackingTags);
    }

    private static class i
    extends com.google.android.gms.drive.internal.c {
        private final BaseImplementation.b<DriveApi.MetadataBufferResult> Ea;

        public i(BaseImplementation.b<DriveApi.MetadataBufferResult> b2) {
            this.Ea = b2;
        }

        @Override
        public void a(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.iR(), null);
            this.Ea.b((Object)new f(Status.Kw, metadataBuffer, onListEntriesResponse.iS()));
        }

        @Override
        public void n(Status status) throws RemoteException {
            this.Ea.b((Object)new f(status, null, false));
        }
    }

    static class f
    implements DriveApi.MetadataBufferResult {
        private final Status Eb;
        private final MetadataBuffer PI;
        private final boolean PJ;

        public f(Status status, MetadataBuffer metadataBuffer, boolean bl) {
            this.Eb = status;
            this.PI = metadataBuffer;
            this.PJ = bl;
        }

        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.PI;
        }
    }

    static abstract class g
    extends q<DriveApi.MetadataBufferResult> {
        g(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.MetadataBufferResult q(Status status) {
            return new f(status, null, false);
        }

        public /* synthetic */ Result c(Status status) {
            return this.q(status);
        }
    }

    static class c
    extends com.google.android.gms.drive.internal.c {
        private final BaseImplementation.b<DriveApi.DriveIdResult> Ea;

        public c(BaseImplementation.b<DriveApi.DriveIdResult> b2) {
            this.Ea = b2;
        }

        @Override
        public void a(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.Ea.b((Object)new d(Status.Kw, new m(onMetadataResponse.iU()).getDriveId()));
        }

        @Override
        public void a(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.Ea.b((Object)new d(Status.Kw, onDriveIdResponse.getDriveId()));
        }

        @Override
        public void n(Status status) throws RemoteException {
            this.Ea.b((Object)new d(status, null));
        }
    }

    private static class d
    implements DriveApi.DriveIdResult {
        private final Status Eb;
        private final DriveId Oj;

        public d(Status status, DriveId driveId) {
            this.Eb = status;
            this.Oj = driveId;
        }

        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public DriveId getDriveId() {
            return this.Oj;
        }
    }

    static abstract class e
    extends q<DriveApi.DriveIdResult> {
        e(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveIdResult p(Status status) {
            return new d(status, null);
        }

        public /* synthetic */ Result c(Status status) {
            return this.p(status);
        }
    }

    private static class h
    extends com.google.android.gms.drive.internal.c {
        private final BaseImplementation.b<DriveApi.DriveContentsResult> Ea;

        public h(BaseImplementation.b<DriveApi.DriveContentsResult> b2) {
            this.Ea = b2;
        }

        @Override
        public void a(OnContentsResponse onContentsResponse) throws RemoteException {
            this.Ea.b((Object)new a(Status.Kw, new s(onContentsResponse.iL())));
        }

        @Override
        public void n(Status status) throws RemoteException {
            this.Ea.b((Object)new a(status, null));
        }
    }

    static class a
    implements DriveApi.DriveContentsResult {
        private final Status Eb;
        private final DriveContents Om;

        public a(Status status, DriveContents driveContents) {
            this.Eb = status;
            this.Om = driveContents;
        }

        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public DriveContents getDriveContents() {
            return this.Om;
        }
    }

    static abstract class b
    extends q<DriveApi.DriveContentsResult> {
        b(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveContentsResult o(Status status) {
            return new a(status, null);
        }

        public /* synthetic */ Result c(Status status) {
            return this.o(status);
        }
    }

    static class j
    extends q.a {
        j(GoogleApiClient googleApiClient, Status status) {
            super(googleApiClient);
            this.b((Result)status);
        }

        protected void a(r r2) {
        }
    }
}

