/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.ij;
import com.google.android.gms.internal.in;
import com.google.android.gms.internal.io;
import com.google.android.gms.internal.iq;
import com.google.android.gms.internal.ir;
import com.google.android.gms.internal.is;
import com.google.android.gms.internal.jl;
import com.google.android.gms.internal.js;
import com.google.android.gms.internal.jt;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class im
extends jl<iq> {
    private static final is Hh = new is("CastClientImpl");
    private ApplicationMetadata Hi;
    private final CastDevice Hj;
    private final Cast.Listener FD;
    private final Handler mHandler;
    private final Map<String, Cast.MessageReceivedCallback> Hk;
    private final long Hl;
    private c Hm;
    private String Hn;
    private boolean Gq;
    private boolean Ho;
    private boolean Hp;
    private boolean Hq;
    private double Gp;
    private int Hr;
    private int Hs;
    private final AtomicLong Ht;
    private String Hu;
    private String Hv;
    private Bundle Hw;
    private final Map<Long, BaseImplementation.b<Status>> Hx;
    private final b Hy;
    private BaseImplementation.b<Cast.ApplicationConnectionResult> Hz;
    private BaseImplementation.b<Status> HA;
    private static final Object HB = new Object();
    private static final Object HC = new Object();

    public im(Context context, Looper looper, CastDevice castDevice, long l, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, (String[])null);
        this.Hj = castDevice;
        this.FD = listener;
        this.Hl = l;
        this.mHandler = new Handler(looper);
        this.Hk = new HashMap<String, Cast.MessageReceivedCallback>();
        this.Ht = new AtomicLong(0L);
        this.Hx = new HashMap<Long, BaseImplementation.b<Status>>();
        this.fW();
        this.Hy = new b();
        this.registerConnectionFailedListener(this.Hy);
    }

    private void fW() {
        this.Hq = false;
        this.Hr = -1;
        this.Hs = -1;
        this.Hi = null;
        this.Hn = null;
        this.Gp = 0.0;
        this.Gq = false;
    }

    protected void a(int n, IBinder iBinder, Bundle bundle) {
        Hh.b("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.Hq = true;
            this.Ho = true;
            this.Hp = true;
        } else {
            this.Hq = false;
        }
        int n2 = n;
        if (n == 1001) {
            this.Hw = new Bundle();
            this.Hw.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n2 = 0;
        }
        super.a(n2, iBinder, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Hh.b("disconnect(); ServiceListener=%s, isConnected=%b", this.Hm, this.isConnected());
        c c2 = this.Hm;
        this.Hm = null;
        if (c2 == null || !c2.gg()) {
            Hh.b("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.ga();
        try {
            if (this.isConnected() || this.isConnecting()) {
                ((iq)this.hw()).disconnect();
            }
        }
        catch (RemoteException remoteException) {
            Hh.a(remoteException, "Error while disconnecting the controller interface: %s", remoteException.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    public Bundle fX() {
        if (this.Hw != null) {
            Bundle bundle = this.Hw;
            this.Hw = null;
            return bundle;
        }
        return super.fX();
    }

    protected String bK() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    protected String bL() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected iq L(IBinder iBinder) {
        return iq.a.M(iBinder);
    }

    protected void a(jt jt2, jl.e e2) throws RemoteException {
        Bundle bundle = new Bundle();
        Hh.b("getServiceFromBroker(): mLastApplicationId=%s, mLastSessionId=%s", this.Hu, this.Hv);
        this.Hj.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.Hl);
        if (this.Hu != null) {
            bundle.putString("last_application_id", this.Hu);
            if (this.Hv != null) {
                bundle.putString("last_session_id", this.Hv);
            }
        }
        this.Hm = new c();
        jt2.a((js)e2, 6587000, this.getContext().getPackageName(), this.Hm.asBinder(), bundle);
    }

    public void a(String string, String string2, BaseImplementation.b<Status> b2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string2.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        in.aF(string);
        this.gb();
        long l = this.Ht.incrementAndGet();
        try {
            this.Hx.put(l, b2);
            ((iq)this.hw()).a(string, string2, l);
        }
        catch (Throwable throwable) {
            this.Hx.remove(l);
            throw throwable;
        }
    }

    public void a(String string, boolean bl, BaseImplementation.b<Cast.ApplicationConnectionResult> b2) throws IllegalStateException, RemoteException {
        this.c(b2);
        ((iq)this.hw()).g(string, bl);
    }

    public void a(String string, LaunchOptions launchOptions, BaseImplementation.b<Cast.ApplicationConnectionResult> b2) throws IllegalStateException, RemoteException {
        this.c(b2);
        ((iq)this.hw()).a(string, launchOptions);
    }

    public void b(String string, String string2, BaseImplementation.b<Cast.ApplicationConnectionResult> b2) throws IllegalStateException, RemoteException {
        this.c(b2);
        ((iq)this.hw()).k(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(BaseImplementation.b<Cast.ApplicationConnectionResult> b2) {
        Object object = HB;
        synchronized (object) {
            if (this.Hz != null) {
                this.Hz.b((Object)new a(new Status(2002)));
            }
            this.Hz = b2;
        }
    }

    public void d(BaseImplementation.b<Status> b2) throws IllegalStateException, RemoteException {
        this.e(b2);
        ((iq)this.hw()).gl();
    }

    public void a(String string, BaseImplementation.b<Status> b2) throws IllegalStateException, RemoteException {
        this.e(b2);
        ((iq)this.hw()).aH(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e(BaseImplementation.b<Status> b2) {
        Object object = HC;
        synchronized (object) {
            if (this.HA != null) {
                b2.b((Object)new Status(2001));
                return;
            }
            this.HA = b2;
        }
    }

    public void fY() throws IllegalStateException, RemoteException {
        ((iq)this.hw()).fY();
    }

    public void a(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        ((iq)this.hw()).a(d, this.Gp, this.Gq);
    }

    public void I(boolean bl) throws IllegalStateException, RemoteException {
        ((iq)this.hw()).a(bl, this.Gp, this.Gq);
    }

    public double fZ() throws IllegalStateException {
        this.gb();
        return this.Gp;
    }

    public boolean isMute() throws IllegalStateException {
        this.gb();
        return this.Gq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(String string, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        in.aF(string);
        this.aE(string);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.Hk;
            synchronized (map) {
                this.Hk.put(string, messageReceivedCallback);
            }
            ((iq)this.hw()).aI(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aE(String string) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.Hk;
        synchronized (map) {
            messageReceivedCallback = this.Hk.remove(string);
        }
        if (messageReceivedCallback != null) {
            try {
                ((iq)this.hw()).aJ(string);
            }
            catch (IllegalStateException illegalStateException) {
                Hh.a(illegalStateException, "Error unregistering namespace (%s): %s", string, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.gb();
        return this.Hi;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.gb();
        return this.Hn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ga() {
        Hh.b("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.Hk;
        synchronized (map) {
            this.Hk.clear();
        }
    }

    private void a(io io2) {
        boolean bl;
        ApplicationMetadata applicationMetadata = io2.getApplicationMetadata();
        if (!in.a(applicationMetadata, this.Hi)) {
            this.Hi = applicationMetadata;
            this.FD.onApplicationMetadataChanged(this.Hi);
        }
        boolean bl2 = false;
        double d = io2.fZ();
        if (d != Double.NaN && d != this.Gp) {
            this.Gp = d;
            bl2 = true;
        }
        if ((bl = io2.gi()) != this.Gq) {
            this.Gq = bl;
            bl2 = true;
        }
        Hh.b("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.Hp);
        if (this.FD != null && (bl2 || this.Hp)) {
            this.FD.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = io2.gj();
        if (n != this.Hr) {
            this.Hr = n;
            bl3 = true;
        }
        Hh.b("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.Hp);
        if (this.FD != null && (bl3 || this.Hp)) {
            this.FD.X(this.Hr);
        }
        boolean bl4 = false;
        int n2 = io2.gk();
        if (n2 != this.Hs) {
            this.Hs = n2;
            bl4 = true;
        }
        Hh.b("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.Hp);
        if (this.FD != null && (bl4 || this.Hp)) {
            this.FD.Y(this.Hs);
        }
        this.Hp = false;
    }

    private void a(ij ij2) {
        boolean bl = false;
        String string = ij2.fT();
        if (!in.a(string, this.Hn)) {
            this.Hn = string;
            bl = true;
        }
        Hh.b("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.Ho);
        if (this.FD != null && (bl || this.Ho)) {
            this.FD.onApplicationStatusChanged();
        }
        this.Ho = false;
    }

    private void gb() throws IllegalStateException {
        if (!this.Hq || this.Hm == null || this.Hm.gh()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected /* synthetic */ IInterface l(IBinder iBinder) {
        return this.L(iBinder);
    }

    private class c
    extends ir.a {
        private final AtomicBoolean HH = new AtomicBoolean(false);

        private c() {
        }

        public boolean gg() {
            if (this.HH.getAndSet(true)) {
                return false;
            }
            im.this.fW();
            return true;
        }

        public boolean gh() {
            return this.HH.get();
        }

        @Override
        public void ad(int n) {
            if (!this.gg()) {
                return;
            }
            Hh.b("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                im.this.aD(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void a(ApplicationMetadata applicationMetadata, String string, String string2, boolean bl) {
            if (this.HH.get()) {
                return;
            }
            im.this.Hi = applicationMetadata;
            im.this.Hu = applicationMetadata.getApplicationId();
            im.this.Hv = string2;
            Object object = HB;
            synchronized (object) {
                if (im.this.Hz != null) {
                    im.this.Hz.b((Object)new a(new Status(0), applicationMetadata, string, string2, bl));
                    im.this.Hz = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ae(int n) {
            if (this.HH.get()) {
                return;
            }
            Object object = HB;
            synchronized (object) {
                if (im.this.Hz != null) {
                    im.this.Hz.b((Object)new a(new Status(n)));
                    im.this.Hz = null;
                }
            }
        }

        @Override
        public void af(int n) {
            if (this.HH.get()) {
                return;
            }
            this.ah(n);
        }

        @Override
        public void ag(int n) {
            if (this.HH.get()) {
                return;
            }
            this.ah(n);
        }

        @Override
        public void onApplicationDisconnected(final int statusCode) {
            if (this.HH.get()) {
                return;
            }
            im.this.Hu = null;
            im.this.Hv = null;
            this.ah(statusCode);
            if (im.this.FD != null) {
                im.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (im.this.FD != null) {
                            im.this.FD.onApplicationDisconnected(statusCode);
                        }
                    }
                });
            }
        }

        @Override
        public void a(String string, double d, boolean bl) {
            Hh.b("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void b(final io io2) {
            if (this.HH.get()) {
                return;
            }
            Hh.b("onDeviceStatusChanged", new Object[0]);
            im.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    im.this.a(io2);
                }
            });
        }

        @Override
        public void b(final ij ij2) {
            if (this.HH.get()) {
                return;
            }
            Hh.b("onApplicationStatusChanged", new Object[0]);
            im.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    im.this.a(ij2);
                }
            });
        }

        @Override
        public void j(final String string, final String string2) {
            if (this.HH.get()) {
                return;
            }
            Hh.b("Receive (type=text, ns=%s) %s", string, string2);
            im.this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = im.this.Hk;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)im.this.Hk.get(string);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(im.this.Hj, string, string2);
                    } else {
                        Hh.b("Discarded message for unknown namespace '%s'", string);
                    }
                }
            });
        }

        @Override
        public void b(String string, byte[] byArray) {
            if (this.HH.get()) {
                return;
            }
            Hh.b("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string, byArray.length);
        }

        @Override
        public void a(String string, long l, int n) {
            if (this.HH.get()) {
                return;
            }
            this.c(l, n);
        }

        @Override
        public void a(String string, long l) {
            if (this.HH.get()) {
                return;
            }
            this.c(l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void c(long l, int n) {
            BaseImplementation.b b2 = null;
            Map map = im.this.Hx;
            synchronized (map) {
                b2 = (BaseImplementation.b)im.this.Hx.remove(l);
            }
            if (b2 != null) {
                b2.b((Object)new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean ah(int n) {
            Object object = HC;
            synchronized (object) {
                if (im.this.HA != null) {
                    im.this.HA.b((Object)new Status(n));
                    im.this.HA = null;
                    return true;
                }
            }
            return false;
        }
    }

    private class b
    implements GoogleApiClient.OnConnectionFailedListener {
        private b() {
        }

        public void onConnectionFailed(ConnectionResult result) {
            im.this.ga();
        }
    }

    private static final class a
    implements Cast.ApplicationConnectionResult {
        private final Status Eb;
        private final ApplicationMetadata HD;
        private final String HE;
        private final String vZ;
        private final boolean HF;

        public a(Status status, ApplicationMetadata applicationMetadata, String string, String string2, boolean bl) {
            this.Eb = status;
            this.HD = applicationMetadata;
            this.HE = string;
            this.vZ = string2;
            this.HF = bl;
        }

        public a(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.HD;
        }

        @Override
        public String getApplicationStatus() {
            return this.HE;
        }

        @Override
        public String getSessionId() {
            return this.vZ;
        }

        @Override
        public boolean getWasLaunched() {
            return this.HF;
        }
    }
}

