/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.internal.in;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.li;
import com.google.android.gms.internal.ll;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    private float GT;
    private int GU;
    private int xB;
    private int GV;
    private int GW;
    private int GX;
    private int GY;
    private int GZ;
    private String Ha;
    private int Hb;
    private int Hc;
    private JSONObject Ga;

    public TextTrackStyle() {
        this.clear();
    }

    public void setFontScale(float fontScale) {
        this.GT = fontScale;
    }

    public float getFontScale() {
        return this.GT;
    }

    public void setForegroundColor(int foregroundColor) {
        this.GU = foregroundColor;
    }

    public int getForegroundColor() {
        return this.GU;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.xB = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.xB;
    }

    public void setEdgeType(int edgeType) {
        if (edgeType < 0 || edgeType > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.GV = edgeType;
    }

    public int getEdgeType() {
        return this.GV;
    }

    public void setEdgeColor(int edgeColor) {
        this.GW = edgeColor;
    }

    public int getEdgeColor() {
        return this.GW;
    }

    public void setWindowType(int windowType) {
        if (windowType < 0 || windowType > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.GX = windowType;
    }

    public int getWindowType() {
        return this.GX;
    }

    public void setWindowColor(int windowColor) {
        this.GY = windowColor;
    }

    public int getWindowColor() {
        return this.GY;
    }

    public void setWindowCornerRadius(int windowCornerRadius) {
        if (windowCornerRadius < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.GZ = windowCornerRadius;
    }

    public int getWindowCornerRadius() {
        return this.GZ;
    }

    public void setFontFamily(String fontFamily) {
        this.Ha = fontFamily;
    }

    public String getFontFamily() {
        return this.Ha;
    }

    public void setFontGenericFamily(int fontGenericFamily) {
        if (fontGenericFamily < 0 || fontGenericFamily > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.Hb = fontGenericFamily;
    }

    public int getFontGenericFamily() {
        return this.Hb;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle < 0 || fontStyle > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.Hc = fontStyle;
    }

    public int getFontStyle() {
        return this.Hc;
    }

    public void setCustomData(JSONObject customData) {
        this.Ga = customData;
    }

    public JSONObject getCustomData() {
        return this.Ga;
    }

    private void clear() {
        this.GT = 1.0f;
        this.GU = 0;
        this.xB = 0;
        this.GV = -1;
        this.GW = 0;
        this.GX = -1;
        this.GY = 0;
        this.GZ = 0;
        this.Ha = null;
        this.Hb = -1;
        this.Hc = -1;
        this.Ga = null;
    }

    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!ll.im()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void c(JSONObject jSONObject) throws JSONException {
        String string;
        this.clear();
        this.GT = (float)jSONObject.optDouble("fontScale", 1.0);
        this.GU = this.aC(jSONObject.optString("foregroundColor"));
        this.xB = this.aC(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string = jSONObject.getString("edgeType");
            if ("NONE".equals(string)) {
                this.GV = 0;
            } else if ("OUTLINE".equals(string)) {
                this.GV = 1;
            } else if ("DROP_SHADOW".equals(string)) {
                this.GV = 2;
            } else if ("RAISED".equals(string)) {
                this.GV = 3;
            } else if ("DEPRESSED".equals(string)) {
                this.GV = 4;
            }
        }
        this.GW = this.aC(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string = jSONObject.getString("windowType");
            if ("NONE".equals(string)) {
                this.GX = 0;
            } else if ("NORMAL".equals(string)) {
                this.GX = 1;
            } else if ("ROUNDED_CORNERS".equals(string)) {
                this.GX = 2;
            }
        }
        this.GY = this.aC(jSONObject.optString("windowColor"));
        if (this.GX == 2) {
            this.GZ = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.Ha = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string)) {
                this.Hb = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string)) {
                this.Hb = 1;
            } else if ("SERIF".equals(string)) {
                this.Hb = 2;
            } else if ("MONOSPACED_SERIF".equals(string)) {
                this.Hb = 3;
            } else if ("CASUAL".equals(string)) {
                this.Hb = 4;
            } else if ("CURSIVE".equals(string)) {
                this.Hb = 5;
            } else if ("SMALL_CAPITALS".equals(string)) {
                this.Hb = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string)) {
                this.Hc = 0;
            } else if ("BOLD".equals(string)) {
                this.Hc = 1;
            } else if ("ITALIC".equals(string)) {
                this.Hc = 2;
            } else if ("BOLD_ITALIC".equals(string)) {
                this.Hc = 3;
            }
        }
        this.Ga = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.GT);
            if (this.GU != 0) {
                jSONObject.put("foregroundColor", (Object)this.u(this.GU));
            }
            if (this.xB != 0) {
                jSONObject.put("backgroundColor", (Object)this.u(this.xB));
            }
            switch (this.GV) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.GW != 0) {
                jSONObject.put("edgeColor", (Object)this.u(this.GW));
            }
            switch (this.GX) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.GY != 0) {
                jSONObject.put("windowColor", (Object)this.u(this.GY));
            }
            if (this.GX == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.GZ);
            }
            if (this.Ha != null) {
                jSONObject.put("fontFamily", (Object)this.Ha);
            }
            switch (this.Hb) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.Hc) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.Ga != null) {
                jSONObject.put("customData", (Object)this.Ga);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String u(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private int aC(String string) {
        if (string != null && string.length() == 9 && string.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string.substring(1, 3), 16);
                int n2 = Integer.parseInt(string.substring(3, 5), 16);
                int n3 = Integer.parseInt(string.substring(5, 7), 16);
                int n4 = Integer.parseInt(string.substring(7, 9), 16);
                return Color.argb((int)n4, (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)other;
        if (this.Ga == null != (textTrackStyle.Ga == null)) {
            return false;
        }
        if (this.Ga != null && textTrackStyle.Ga != null && !li.d((Object)this.Ga, (Object)textTrackStyle.Ga)) {
            return false;
        }
        return this.GT == textTrackStyle.GT && this.GU == textTrackStyle.GU && this.xB == textTrackStyle.xB && this.GV == textTrackStyle.GV && this.GW == textTrackStyle.GW && this.GX == textTrackStyle.GX && this.GZ == textTrackStyle.GZ && in.a(this.Ha, textTrackStyle.Ha) && this.Hb == textTrackStyle.Hb && this.Hc == textTrackStyle.Hc;
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{Float.valueOf(this.GT), this.GU, this.xB, this.GV, this.GW, this.GX, this.GY, this.GZ, this.Ha, this.Hb, this.Hc, this.Ga});
    }
}

