/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.im;
import com.google.android.gms.internal.it;
import com.google.android.gms.internal.iu;
import com.google.android.gms.internal.iv;
import java.io.IOException;
import org.json.JSONObject;

public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object mH = new Object();
    private final it Gw;
    private final a Gx = new a();
    private OnMetadataUpdatedListener Gy;
    private OnStatusUpdatedListener Gz;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_CANCELED = 2101;
    public static final int STATUS_TIMED_OUT = 2102;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaPlayer() {
        this.Gw = new it(){

            @Override
            protected void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            protected void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }
        };
        this.Gw.a(this.Gx);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo) {
        return this.load(apiClient, mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay) {
        return this.load(apiClient, mediaInfo, autoplay, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition, JSONObject customData) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, customData);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient apiClient, final MediaInfo mediaInfo, final boolean autoplay, final long playPosition, final long[] activeTrackIds, final JSONObject customData) {
        return apiClient.b((BaseImplementation.a)new b(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(im im2) {
                Object object = RemoteMediaPlayer.this.mH;
                synchronized (object) {
                    RemoteMediaPlayer.this.Gx.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.Gw.a(this.GR, mediaInfo, autoplay, playPosition, activeTrackIds, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.k(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.Gx.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient apiClient) {
        return this.pause(apiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b((BaseImplementation.a)new b(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(im im2) {
                Object object = RemoteMediaPlayer.this.mH;
                synchronized (object) {
                    RemoteMediaPlayer.this.Gx.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.Gw.a(this.GR, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.k(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.Gx.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient apiClient) {
        return this.stop(apiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b((BaseImplementation.a)new b(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(im im2) {
                Object object = RemoteMediaPlayer.this.mH;
                synchronized (object) {
                    RemoteMediaPlayer.this.Gx.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.Gw.b(this.GR, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.k(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.Gx.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient apiClient) {
        return this.play(apiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b((BaseImplementation.a)new b(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(im im2) {
                Object object = RemoteMediaPlayer.this.mH;
                synchronized (object) {
                    RemoteMediaPlayer.this.Gx.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.Gw.c(this.GR, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.k(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.Gx.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position) {
        return this.seek(apiClient, position, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position, int resumeState) {
        return this.seek(apiClient, position, resumeState, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient apiClient, final long position, final int resumeState, final JSONObject customData) {
        return apiClient.b((BaseImplementation.a)new b(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(im im2) {
                Object object = RemoteMediaPlayer.this.mH;
                synchronized (object) {
                    RemoteMediaPlayer.this.Gx.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.Gw.a(this.GR, position, resumeState, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.k(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.Gx.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient apiClient, double volume) throws IllegalArgumentException {
        return this.setStreamVolume(apiClient, volume, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient apiClient, final double volume, final JSONObject customData) throws IllegalArgumentException {
        if (Double.isInfinite(volume) || Double.isNaN(volume)) {
            throw new IllegalArgumentException("Volume cannot be " + volume);
        }
        return apiClient.b((BaseImplementation.a)new b(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(im im2) {
                Object object = RemoteMediaPlayer.this.mH;
                synchronized (object) {
                    RemoteMediaPlayer.this.Gx.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.Gw.a(this.GR, volume, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.b(this.k(new Status(2100)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.b(this.k(new Status(2100)));
                    }
                    catch (IOException iOException) {
                        this.b(this.k(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.Gx.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient apiClient, boolean muteState) {
        return this.setStreamMute(apiClient, muteState, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient apiClient, final boolean muteState, final JSONObject customData) {
        return apiClient.b((BaseImplementation.a)new b(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(im im2) {
                Object object = RemoteMediaPlayer.this.mH;
                synchronized (object) {
                    RemoteMediaPlayer.this.Gx.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.Gw.a(this.GR, muteState, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.b(this.k(new Status(2100)));
                    }
                    catch (IOException iOException) {
                        this.b(this.k(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.Gx.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient apiClient) {
        return apiClient.b((BaseImplementation.a)new b(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(im im2) {
                Object object = RemoteMediaPlayer.this.mH;
                synchronized (object) {
                    RemoteMediaPlayer.this.Gx.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.Gw.a(this.GR);
                    }
                    catch (IOException iOException) {
                        this.b(this.k(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.Gx.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final GoogleApiClient apiClient, final long[] trackIds) {
        if (trackIds == null || trackIds.length == 0) {
            throw new IllegalArgumentException("trackIds cannot be null or empty");
        }
        return apiClient.b((BaseImplementation.a)new b(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(im im2) {
                Object object = RemoteMediaPlayer.this.mH;
                synchronized (object) {
                    RemoteMediaPlayer.this.Gx.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.Gw.a(this.GR, trackIds);
                    }
                    catch (IOException iOException) {
                        this.b(this.k(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.Gx.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final GoogleApiClient apiClient, final TextTrackStyle trackStyle) {
        if (trackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return apiClient.b((BaseImplementation.a)new b(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(im im2) {
                Object object = RemoteMediaPlayer.this.mH;
                synchronized (object) {
                    RemoteMediaPlayer.this.Gx.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.Gw.a(this.GR, trackStyle);
                    }
                    catch (IOException iOException) {
                        this.b(this.k(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.Gx.b(null);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.mH;
        synchronized (object) {
            return this.Gw.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.mH;
        synchronized (object) {
            return this.Gw.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.mH;
        synchronized (object) {
            return this.Gw.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.mH;
        synchronized (object) {
            return this.Gw.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener listener) {
        this.Gz = listener;
    }

    private void onStatusUpdated() {
        if (this.Gz != null) {
            this.Gz.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener listener) {
        this.Gy = listener;
    }

    private void onMetadataUpdated() {
        if (this.Gy != null) {
            this.Gy.onMetadataUpdated();
        }
    }

    public String getNamespace() {
        return this.Gw.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
        this.Gw.aD(message);
    }

    private static abstract class b
    extends Cast.a<MediaChannelResult> {
        iv GR = new iv(){

            @Override
            public void n(long l) {
                b.this.b(b.this.k(new Status(2103)));
            }

            @Override
            public void a(long l, int n, JSONObject jSONObject) {
                b.this.b(new c(new Status(n), jSONObject));
            }
        };

        b(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult k(final Status status) {
            return new MediaChannelResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.k(status);
        }
    }

    private static final class c
    implements MediaChannelResult {
        private final Status Eb;
        private final JSONObject Ga;

        c(Status status, JSONObject jSONObject) {
            this.Eb = status;
            this.Ga = jSONObject;
        }

        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public JSONObject getCustomData() {
            return this.Ga;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$a
    implements iu {
        private GoogleApiClient GN;
        private long GO = 0L;

        public void b(GoogleApiClient googleApiClient) {
            this.GN = googleApiClient;
        }

        @Override
        public long fS() {
            return ++this.GO;
        }

        @Override
        public void a(String string, String string2, long l, String string3) throws IOException {
            if (this.GN == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.GN, string, string2).setResultCallback((ResultCallback)new a(l));
        }

        private final class a
        implements ResultCallback<Status> {
            private final long GP;

            a(long l) {
                this.GP = l;
            }

            public void j(Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.Gw.b(this.GP, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.j((Status)x0);
            }
        }
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

