/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.internal.in;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.li;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long Eg;
    private int Gt;
    private String FT;
    private String FV;
    private String mName;
    private String FR;
    private int Gu;
    private JSONObject Ga;

    MediaTrack(JSONObject json) throws JSONException {
        this.c(json);
    }

    MediaTrack(long id, int type) throws IllegalArgumentException {
        this.clear();
        this.Eg = id;
        if (type <= 0 || type > 3) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.Gt = type;
    }

    public long getId() {
        return this.Eg;
    }

    public int getType() {
        return this.Gt;
    }

    public String getContentId() {
        return this.FT;
    }

    public void setContentId(String contentId) {
        this.FT = contentId;
    }

    public String getContentType() {
        return this.FV;
    }

    public void setContentType(String contentType) {
        this.FV = contentType;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getLanguage() {
        return this.FR;
    }

    void setLanguage(String language) {
        this.FR = language;
    }

    public int getSubtype() {
        return this.Gu;
    }

    void ab(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException("invalid subtype " + n);
        }
        if (n != 0 && this.Gt != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.Gu = n;
    }

    public JSONObject getCustomData() {
        return this.Ga;
    }

    void setCustomData(JSONObject customData) {
        this.Ga = customData;
    }

    private void clear() {
        this.Eg = 0L;
        this.Gt = 0;
        this.FT = null;
        this.mName = null;
        this.FR = null;
        this.Gu = -1;
        this.Ga = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void c(JSONObject jSONObject) throws JSONException {
        this.clear();
        this.Eg = jSONObject.getLong("trackId");
        String string = jSONObject.getString("type");
        if ("TEXT".equals(string)) {
            this.Gt = 1;
        } else if ("AUDIO".equals(string)) {
            this.Gt = 2;
        } else {
            if (!"VIDEO".equals(string)) throw new JSONException("invalid type: " + string);
            this.Gt = 3;
        }
        this.FT = jSONObject.optString("trackContentId", null);
        this.FV = jSONObject.optString("trackContentType", null);
        this.mName = jSONObject.optString("name", null);
        this.FR = jSONObject.optString("language", null);
        if (jSONObject.has("subtype")) {
            string = jSONObject.getString("subtype");
            if ("SUBTITLES".equals(string)) {
                this.Gu = 1;
            } else if ("CAPTIONS".equals(string)) {
                this.Gu = 2;
            } else if ("DESCRIPTIONS".equals(string)) {
                this.Gu = 3;
            } else if ("CHAPTERS".equals(string)) {
                this.Gu = 4;
            } else {
                if (!"METADATA".equals(string)) throw new JSONException("invalid subtype: " + string);
                this.Gu = 5;
            }
        } else {
            this.Gu = 0;
        }
        this.Ga = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.Eg);
            switch (this.Gt) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.FT != null) {
                jSONObject.put("trackContentId", (Object)this.FT);
            }
            if (this.FV != null) {
                jSONObject.put("trackContentType", (Object)this.FV);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.FR)) {
                jSONObject.put("language", (Object)this.FR);
            }
            switch (this.Gu) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.Ga != null) {
                jSONObject.put("customData", (Object)this.Ga);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)other;
        if (this.Ga == null != (mediaTrack.Ga == null)) {
            return false;
        }
        if (this.Ga != null && mediaTrack.Ga != null && !li.d((Object)this.Ga, (Object)mediaTrack.Ga)) {
            return false;
        }
        return this.Eg == mediaTrack.Eg && this.Gt == mediaTrack.Gt && in.a(this.FT, mediaTrack.FT) && in.a(this.FV, mediaTrack.FV) && in.a(this.mName, mediaTrack.mName) && in.a(this.FR, mediaTrack.FR) && this.Gu == mediaTrack.Gu;
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.Eg, this.Gt, this.FT, this.FV, this.mName, this.FR, this.Gu, this.Ga});
    }

    public static class Builder {
        private final MediaTrack Gv;

        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            this.Gv = new MediaTrack(trackId, trackType);
        }

        public Builder setContentId(String contentId) {
            this.Gv.setContentId(contentId);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.Gv.setContentType(contentType);
            return this;
        }

        public Builder setName(String trackName) {
            this.Gv.setName(trackName);
            return this;
        }

        public Builder setLanguage(String language) {
            this.Gv.setLanguage(language);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.Gv.setLanguage(in.b(locale));
            return this;
        }

        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            this.Gv.ab(subtype);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.Gv.setCustomData(customData);
            return this;
        }

        public MediaTrack build() {
            return this.Gv;
        }
    }
}

