/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.internal.in;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    private long Gj;
    private MediaInfo Gb;
    private double Gk;
    private int Gl;
    private int Gm;
    private long Gn;
    private long Go;
    private double Gp;
    private boolean Gq;
    private long[] Gr;
    private JSONObject Ga;
    private static final long[] Gs = new long[0];

    public MediaStatus(JSONObject json) throws JSONException {
        this.a(json, 0);
    }

    public long fR() {
        return this.Gj;
    }

    public int getPlayerState() {
        return this.Gl;
    }

    public int getIdleReason() {
        return this.Gm;
    }

    public double getPlaybackRate() {
        return this.Gk;
    }

    public MediaInfo getMediaInfo() {
        return this.Gb;
    }

    public long getStreamPosition() {
        return this.Gn;
    }

    public boolean isMediaCommandSupported(long mediaCommand) {
        return (this.Go & mediaCommand) != 0L;
    }

    public double getStreamVolume() {
        return this.Gp;
    }

    public boolean isMute() {
        return this.Gq;
    }

    public long[] getActiveTrackIds() {
        return this.Gr != null ? this.Gr : Gs;
    }

    public JSONObject getCustomData() {
        return this.Ga;
    }

    public int a(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        long l;
        long l2;
        double d;
        int n3 = 0;
        long l3 = jSONObject.getLong("mediaSessionId");
        if (l3 != this.Gj) {
            this.Gj = l3;
            n3 |= 1;
        }
        if (jSONObject.has("playerState")) {
            int n4 = 0;
            String string = jSONObject.getString("playerState");
            if (string.equals("IDLE")) {
                n4 = 1;
            } else if (string.equals("PLAYING")) {
                n4 = 2;
            } else if (string.equals("PAUSED")) {
                n4 = 3;
            } else if (string.equals("BUFFERING")) {
                n4 = 4;
            }
            if (n4 != this.Gl) {
                this.Gl = n4;
                n3 |= 2;
            }
            if (n4 == 1 && jSONObject.has("idleReason")) {
                int n5 = 0;
                string = jSONObject.getString("idleReason");
                if (string.equals("CANCELLED")) {
                    n5 = 2;
                } else if (string.equals("INTERRUPTED")) {
                    n5 = 3;
                } else if (string.equals("FINISHED")) {
                    n5 = 1;
                } else if (string.equals("ERROR")) {
                    n5 = 4;
                }
                if (n5 != this.Gm) {
                    this.Gm = n5;
                    n3 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.Gk != (d = jSONObject.getDouble("playbackRate"))) {
            this.Gk = d;
            n3 |= 2;
        }
        if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = in.b(jSONObject.getDouble("currentTime"))) != this.Gn) {
            this.Gn = l2;
            n3 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.Go) {
            this.Go = l;
            n3 |= 2;
        }
        if (jSONObject.has("volume") && (n & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d2 = jSONObject2.getDouble("level");
            if (d2 != this.Gp) {
                this.Gp = d2;
                n3 |= 2;
            }
            if ((n2 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.Gq) {
                this.Gq = n2;
                n3 |= 2;
            }
        }
        boolean bl = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n6;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n2 = jSONArray.length();
            lArray = new long[n2];
            for (n6 = 0; n6 < n2; ++n6) {
                lArray[n6] = jSONArray.getLong(n6);
            }
            if (this.Gr == null) {
                bl = true;
            } else if (this.Gr.length != n2) {
                bl = true;
            } else {
                for (n6 = 0; n6 < n2; ++n6) {
                    if (this.Gr[n6] == lArray[n6]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.Gr = lArray;
            }
        } else if (this.Gr != null) {
            bl = true;
        }
        if (bl) {
            this.Gr = lArray;
            n3 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.Ga = jSONObject.getJSONObject("customData");
            n3 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            this.Gb = new MediaInfo(jSONObject3);
            n3 |= 2;
            if (jSONObject3.has("metadata")) {
                n3 |= 4;
            }
        }
        return n3;
    }
}

