/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appindexing;

import android.net.Uri;
import android.os.Bundle;
import com.google.android.gms.appindexing.Thing;
import com.google.android.gms.internal.jx;

public final class Action
extends Thing {
    public static final String TYPE_ADD = "http://schema.org/AddAction";
    public static final String TYPE_BOOKMARK = "http://schema.org/BookmarkAction";
    public static final String TYPE_LIKE = "http://schema.org/LikeAction";
    public static final String TYPE_LISTEN = "http://schema.org/ListenAction";
    public static final String TYPE_VIEW = "http://schema.org/ViewAction";
    public static final String TYPE_WANT = "http://schema.org/WantAction";
    public static final String TYPE_WATCH = "http://schema.org/WatchAction";

    private Action(Bundle propertyBundle) {
        super(propertyBundle);
    }

    public static Action newAction(String actionType, String objectName, Uri objectId, Uri objectUrl) {
        return new Builder(actionType).setObject(new Thing.Builder().setName(objectName).setId(objectId == null ? null : objectId.toString()).setUrl(objectUrl).build()).build();
    }

    public static Action newAction(String actionType, String objectName, Uri objectUrl) {
        return Action.newAction(actionType, objectName, null, objectUrl);
    }

    public static final class Builder
    extends Thing.Builder {
        public Builder(String actionType) {
            jx.i((Object)actionType);
            super.put("type", actionType);
        }

        @Override
        public Builder setName(String name) {
            return (Builder)super.put("name", name);
        }

        @Override
        public Builder setUrl(Uri webUrl) {
            if (webUrl != null) {
                super.put("url", webUrl.toString());
            }
            return this;
        }

        @Override
        public Builder put(String key, String value) {
            return (Builder)super.put(key, value);
        }

        @Override
        public Builder put(String key, Thing value) {
            return (Builder)super.put(key, value);
        }

        public Builder setObject(Thing thing) {
            jx.i((Object)thing);
            return (Builder)super.put("object", thing);
        }

        @Override
        public Action build() {
            jx.b((Object)this.DJ.get("object"), (Object)"setObject is required before calling build().");
            jx.b((Object)this.DJ.get("type"), (Object)"setType is required before calling build().");
            Bundle bundle = (Bundle)this.DJ.getParcelable("object");
            jx.b((Object)bundle.get("name"), (Object)"Must call setObject() with a valid name. Example: setObject(new Thing.Builder().setName(name).setUrl(url))");
            jx.b((Object)bundle.get("url"), (Object)"Must call setObject() with a valid app url. Example: setObject(new Thing.Builder().setName(name).setUrl(url))");
            return new Action(this.DJ);
        }
    }
}

