/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.zzc;
import com.google.android.gms.internal.zzmi;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.tagmanager.zzaz;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class zzcn
implements zzp.zzf {
    private final Context mContext;
    private final String zzaCk;
    private final ExecutorService zzaEN;
    private zzbf<zzmi.zza> zzaEG;

    zzcn(Context context, String string) {
        this.mContext = context;
        this.zzaCk = string;
        this.zzaEN = Executors.newSingleThreadExecutor();
    }

    @Override
    public void zza(zzbf<zzmi.zza> zzbf2) {
        this.zzaEG = zzbf2;
    }

    @Override
    public void zzwC() {
        this.zzaEN.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzxt();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzxt() {
        if (this.zzaEG == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.zzaEG.zzwB();
        zzbg.zzam("Attempting to load resource from disk");
        if ((zzcb.zzxl().zzxm() == zzcb.zza.zzaEv || zzcb.zzxl().zzxm() == zzcb.zza.zzaEw) && this.zzaCk.equals(zzcb.zzxl().getContainerId())) {
            this.zzaEG.zza(zzbf.zza.zzaDU);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.zzxu());
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.zzaj("Failed to find the resource in the disk");
            this.zzaEG.zza(zzbf.zza.zzaDU);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzmq.zzc(fileInputStream, byteArrayOutputStream);
            zzmi.zza zza2 = zzmi.zza.zzo(byteArrayOutputStream.toByteArray());
            this.zzd(zza2);
            this.zzaEG.zzv(zza2);
        }
        catch (IOException iOException) {
            this.zzaEG.zza(zzbf.zza.zzaDV);
            zzbg.zzan("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzaEG.zza(zzbf.zza.zzaDV);
            zzbg.zzan("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzan("Error closing stream for reading resource from disk");
            }
        }
        zzbg.zzam("The Disk resource was successfully read.");
    }

    @Override
    public void zzb(final zzmi.zza zza2) {
        this.zzaEN.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzc(zza2);
            }
        });
    }

    @Override
    public zzmq.zzc zzhC(int n) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbg.zzan("Failed to load the container. No default container resource found with the resource ID " + n);
            return null;
        }
        zzbg.zzam("Attempting to load a container from the resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzmq.zzc(inputStream, byteArrayOutputStream);
            zzmq.zzc zzc2 = this.zza(byteArrayOutputStream);
            if (zzc2 != null) {
                zzbg.zzam("The container was successfully loaded from the resource (using JSON file format)");
                return zzc2;
            }
            return this.zzn(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            zzbg.zzan("Error reading the default container with resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
            return null;
        }
    }

    private zzmq.zzc zza(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = byteArrayOutputStream.toString("UTF-8");
            return zzaz.zzdQ(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            zzbg.zzaj("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            zzbg.zzan("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private zzmq.zzc zzn(byte[] byArray) {
        try {
            zzmq.zzc zzc2 = zzmq.zzb(zzc.zzf.zza(byArray));
            if (zzc2 != null) {
                zzbg.zzam("The container was successfully loaded from the resource (using binary file)");
            }
            return zzc2;
        }
        catch (zznx zznx2) {
            zzbg.zzak("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (zzmq.zzg zzg2) {
            zzbg.zzan("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    public synchronized void release() {
        this.zzaEN.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzc(zzmi.zza zza2) {
        FileOutputStream fileOutputStream = null;
        File file = this.zzxu();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.zzak("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(zzny.zzf((zzny)zza2));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            zzbg.zzan("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzan("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File zzxu() {
        String string = "resource_" + this.zzaCk;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string);
    }

    private void zzd(zzmi.zza zza2) throws IllegalArgumentException {
        if (zza2.zzhh == null && zza2.zzaGM == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

