/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkj;
import com.google.android.gms.internal.zzkl;
import com.google.android.gms.internal.zzkm;
import com.google.android.gms.internal.zzkp;
import com.google.android.gms.internal.zzkr;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzkk {
    private static volatile zzkk zzawk;
    private final Context mContext;
    private final List<zzkl> zzawl;
    private final zzkf zzawm;
    private final zza zzawn;
    private volatile zzkp zzGq;
    private Thread.UncaughtExceptionHandler zzawo;

    zzkk(Context context) {
        Context context2 = context.getApplicationContext();
        zzv.zzr((Object)context2);
        this.mContext = context2;
        this.zzawn = new zza();
        this.zzawl = new CopyOnWriteArrayList<zzkl>();
        this.zzawm = new zzkf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzkk zzak(Context context) {
        zzv.zzr((Object)context);
        if (zzawk != null) return zzawk;
        Class<zzkk> clazz = zzkk.class;
        synchronized (zzkk.class) {
            if (zzawk != null) return zzawk;
            zzawk = new zzkk(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzawk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzkp zzum() {
        if (this.zzGq == null) {
            zzkk zzkk2 = this;
            synchronized (zzkk2) {
                if (this.zzGq == null) {
                    zzkp zzkp2 = new zzkp();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzkp2.setAppId(string);
                    zzkp2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)"GAv4", (String)("Error retrieving package info: appName set to " + string2));
                    }
                    zzkp2.setAppName(string2);
                    zzkp2.setAppVersion(string3);
                    this.zzGq = zzkp2;
                }
            }
        }
        return this.zzGq;
    }

    public zzkr zzun() {
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzkr zzkr2 = new zzkr();
        zzkr2.setLanguage(zzal.zza(Locale.getDefault()));
        zzkr2.zzgE(displayMetrics.widthPixels);
        zzkr2.zzgF(displayMetrics.heightPixels);
        return zzkr2;
    }

    void zze(zzkg zzkg2) {
        if (zzkg2.zzui()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzkg2.zzue()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        final zzkg zzkg3 = zzkg2.zztZ();
        zzkg3.zzuf();
        this.zzawn.execute(new Runnable(){

            @Override
            public void run() {
                zzkj zzkj2 = zzkg3.zzug();
                zzkj2.zza(zzkg3);
                for (zzkl zzkl2 : zzkk.this.zzawl) {
                    zzkl2.zza(zzkg3);
                }
                zzkk.this.zzb(zzkg3);
            }
        });
    }

    public Context getContext() {
        return this.mContext;
    }

    public static void zzgF() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzawo = uncaughtExceptionHandler;
    }

    public <V> Future<V> zzb(Callable<V> callable) {
        zzv.zzr(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzawn.submit(callable);
    }

    public void zze(Runnable runnable) {
        zzv.zzr((Object)runnable);
        this.zzawn.submit(runnable);
    }

    private void zzb(zzkg zzkg2) {
        zzv.zzbJ((String)"deliver should be called from worker thread");
        zzv.zzb((boolean)zzkg2.zzue(), (Object)"Measurement must be submitted");
        List<zzkm> list = zzkg2.zzub();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzkm zzkm2 : list) {
            Uri uri = zzkm2.zzfR();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzkm2.zzb(zzkg2);
        }
    }

    private static class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzaws = new AtomicInteger();

        private zzb() {
        }

        @Override
        public Thread newThread(Runnable target) {
            String string = "measurement-" + zzaws.incrementAndGet();
            return new zzc(target, string);
        }
    }

    private static class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    private class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb());
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return new FutureTask<T>(runnable, value){

                @Override
                protected void setException(Throwable error) {
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = zzkk.this.zzawo;
                    if (uncaughtExceptionHandler != null) {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), error);
                    } else if (Log.isLoggable((String)"GAv4", (int)6)) {
                        Log.e((String)"GAv4", (String)("MeasurementExecutor: job failed with " + error));
                    }
                    super.setException(error);
                }
            };
        }
    }
}

