/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.analytics.internal.Command;
import com.google.android.gms.analytics.internal.zzaa;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzs;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.common.stats.zzb;
import java.util.Collections;
import java.util.List;

public class zzh
extends zzd {
    private final zza zzGa;
    private zzab zzGb;
    private final zzs zzGc;
    private zzai zzGd;

    protected zzh(zze zze2) {
        super(zze2);
        this.zzGd = new zzai(zze2.zzgG());
        this.zzGa = new zza();
        this.zzGc = new zzs(zze2){

            @Override
            public void run() {
                zzh.this.zzhh();
            }
        };
    }

    @Override
    protected void zzgb() {
    }

    public boolean isConnected() {
        this.zzgF();
        this.zzgR();
        return this.zzGb != null;
    }

    public boolean zzb(zzaa zzaa2) {
        zzv.zzr((Object)zzaa2);
        this.zzgF();
        this.zzgR();
        zzab zzab2 = this.zzGb;
        if (zzab2 == null) {
            return false;
        }
        String string = zzaa2.zziR() ? this.zzgI().zzid() : this.zzgI().zzie();
        List<Command> list = Collections.emptyList();
        try {
            zzab2.zza(zzaa2.zzhe(), zzaa2.zziP(), string, list);
            this.zzhg();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzaF("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public boolean zzhf() {
        this.zzgF();
        this.zzgR();
        zzab zzab2 = this.zzGb;
        if (zzab2 == null) {
            return false;
        }
        try {
            zzab2.zzgv();
            this.zzhg();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzaF("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private void zzhg() {
        this.zzGd.start();
        this.zzGc.zzr(this.zzgI().zzik());
    }

    public boolean connect() {
        this.zzgF();
        this.zzgR();
        if (this.zzGb != null) {
            return true;
        }
        zzab zzab2 = this.zzGa.zzhi();
        if (zzab2 != null) {
            this.zzGb = zzab2;
            this.zzhg();
            return true;
        }
        return false;
    }

    private void zza(zzab zzab2) {
        this.zzgF();
        this.zzGb = zzab2;
        this.zzhg();
        this.zzfZ().onServiceConnected();
    }

    public void disconnect() {
        this.zzgF();
        this.zzgR();
        try {
            zzb zzb2 = zzb.zznb();
            zzb2.zza(this.getContext(), (ServiceConnection)this.zzGa);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.zzGb != null) {
            this.zzGb = null;
            this.onDisconnect();
        }
    }

    private void onServiceDisconnected(ComponentName name) {
        this.zzgF();
        if (this.zzGb != null) {
            this.zzGb = null;
            this.zza("Disconnected from device AnalyticsService", name);
            this.onDisconnect();
        }
    }

    private void zzhh() {
        this.zzgF();
        if (!this.isConnected()) {
            return;
        }
        this.zzaF("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    private void onDisconnect() {
        this.zzfZ().zzgz();
    }

    protected class zza
    implements ServiceConnection {
        private volatile zzab zzGf;
        private volatile boolean zzGg;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public zzab zzhi() {
            zzh.this.zzgF();
            Intent intent = new Intent("com.google.android.gms.analytics.service.START");
            intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
            Context context = zzh.this.getContext();
            intent.putExtra("app_package_name", context.getPackageName());
            zzb zzb2 = zzb.zznb();
            zza zza2 = this;
            synchronized (zza2) {
                this.zzGf = null;
                this.zzGg = true;
                boolean bl = zzb2.zza(context, intent, (ServiceConnection)zzh.this.zzGa, 129);
                zzh.this.zza("Bind to service requested", bl);
                if (!bl) {
                    this.zzGg = false;
                    return null;
                }
                try {
                    long l = zzh.this.zzgI().zzil();
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    zzh.this.zzaI("Wait for service connect was interrupted");
                }
                this.zzGg = false;
                zzab zzab2 = this.zzGf;
                this.zzGf = null;
                if (zzab2 == null) {
                    zzh.this.zzaJ("Successfully bound to service but never got onServiceConnected callback");
                }
                return zzab2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder binder) {
            zzv.zzbI((String)"AnalyticsServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    Object object;
                    if (binder == null) {
                        zzh.this.zzaJ("Service connected with null binder");
                        return;
                    }
                    zzab zzab2 = null;
                    try {
                        object = binder.getInterfaceDescriptor();
                        if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(object)) {
                            zzab2 = zzab.zza.zzG(binder);
                            zzh.this.zzaF("Bound to IAnalyticsService interface");
                        } else {
                            zzh.this.zze("Got binder with a wrong descriptor", object);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzh.this.zzaJ("Service connect failed to get IAnalyticsService");
                    }
                    if (zzab2 == null) {
                        try {
                            zzb.zznb().zza(zzh.this.getContext(), (ServiceConnection)zzh.this.zzGa);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else if (!this.zzGg) {
                        zzh.this.zzaI("onServiceConnected received after the timeout limit");
                        object = zzab2;
                        zzh.this.zzgJ().zze(new Runnable((zzab)object){
                            final /* synthetic */ zzab zzGh;
                            {
                                this.zzGh = zzab2;
                            }

                            @Override
                            public void run() {
                                if (!zzh.this.isConnected()) {
                                    zzh.this.zzaG("Connected to service after a timeout");
                                    zzh.this.zza(this.zzGh);
                                }
                            }
                        });
                    } else {
                        this.zzGf = zzab2;
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }

        public void onServiceDisconnected(final ComponentName name) {
            zzv.zzbI((String)"AnalyticsServiceConnection.onServiceDisconnected");
            zzh.this.zzgJ().zze(new Runnable(){

                @Override
                public void run() {
                    zzh.this.onServiceDisconnected(name);
                }
            });
        }
    }
}

