/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.text.TextUtils;
import com.google.android.gms.analytics.internal.zzae;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzkq;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class zzal {
    private static final char[] zzIO = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Map<String, String> zzaU(String string) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length > 1) {
                hashMap.put(stringArray2[0], stringArray2[1]);
                continue;
            }
            if (stringArray2.length != 1 || stringArray2[0].length() == 0) continue;
            hashMap.put(stringArray2[0], null);
        }
        return hashMap;
    }

    public static double zza(String string, double d) {
        if (string == null) {
            return d;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static long zzaV(String string) {
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static boolean zze(String string, boolean bl) {
        if (string != null) {
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1")) {
                return true;
            }
            if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("0")) {
                return false;
            }
        }
        return bl;
    }

    public static String zzH(boolean bl) {
        return bl ? "1" : "0";
    }

    public static String zzaW(String string) {
        Object object;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string;
        if (string.contains("?") && ((String[])(object = string.split("[\\?]"))).length > 1) {
            string2 = object[1];
        }
        if (string2.contains("%3D")) {
            try {
                string2 = URLDecoder.decode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        } else if (!string2.contains("=")) {
            return null;
        }
        object = zzal.zzaU(string2);
        String[] stringArray = new String[]{"dclid", "utm_source", "gclid", "aclid", "utm_campaign", "utm_medium", "utm_term", "utm_content", "utm_id", "anid", "gmob_t"};
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (TextUtils.isEmpty((CharSequence)((CharSequence)object.get(stringArray[i])))) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(stringArray[i]).append("=").append((String)object.get(stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public static zzkq zza(zzae zzae2, String string) {
        List list;
        zzv.zzr((Object)zzae2);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            list = URLEncodedUtils.parse((URI)new URI("?" + string), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            zzae2.zzd("No valid campaign data found", uRISyntaxException);
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(list.size());
        for (NameValuePair nameValuePair : list) {
            hashMap.put(nameValuePair.getName(), nameValuePair.getValue());
        }
        zzkq zzkq2 = new zzkq();
        zzkq2.zzcU((String)hashMap.get("utm_content"));
        zzkq2.zzcS((String)hashMap.get("utm_medium"));
        zzkq2.setName((String)hashMap.get("utm_campaign"));
        zzkq2.zzcR((String)hashMap.get("utm_source"));
        zzkq2.zzcT((String)hashMap.get("utm_term"));
        zzkq2.zzcV((String)hashMap.get("utm_id"));
        zzkq2.zzcW((String)hashMap.get("anid"));
        zzkq2.zzcX((String)hashMap.get("gclid"));
        zzkq2.zzcY((String)hashMap.get("dclid"));
        zzkq2.zzcZ((String)hashMap.get("aclid"));
        return zzkq2;
    }

    public static String zza(Locale locale) {
        if (locale == null) {
            return null;
        }
        String string = locale.getLanguage();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.toLowerCase());
        if (!TextUtils.isEmpty((CharSequence)locale.getCountry())) {
            stringBuilder.append("-").append(locale.getCountry().toLowerCase());
        }
        return stringBuilder.toString();
    }

    public static void zzb(Map<String, String> map, String string, String string2) {
        if (string2 != null && !map.containsKey(string)) {
            map.put(string, string2);
        }
    }

    public static void zzc(Map<String, String> map, String string, String string2) {
        if (string2 != null && TextUtils.isEmpty((CharSequence)map.get(string))) {
            map.put(string, string2);
        }
    }

    public static void zzb(Map<String, String> map, String string, boolean bl) {
        if (!map.containsKey(string)) {
            map.put(string, bl ? "1" : "0");
        }
    }

    public static void zza(Map<String, String> map, String string, Map<String, String> map2) {
        zzal.zzb(map, string, map2.get(string));
    }

    public static MessageDigest zzaX(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int zzaY(String string) {
        int n = 1;
        int n2 = 0;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            n = 0;
            for (int i = string.length() - 1; i >= 0; --i) {
                char c = string.charAt(i);
                n2 = (n = (n << 6 & 0xFFFFFFF) + c + (c << 14)) & 0xFE00000;
                n = n2 != 0 ? n ^ n2 >> 21 : n;
            }
        }
        return n;
    }

    public static boolean zza(double d, String string) {
        if (d <= 0.0 || d >= 100.0) {
            return false;
        }
        return (double)(zzal.zzaY(string) % 10000) >= d * 100.0;
    }

    public static boolean zzaZ(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        return !string.startsWith("http:");
    }

    public static boolean zza(Context context, Class<? extends BroadcastReceiver> clazz, boolean bl) {
        try {
            ActivityInfo activityInfo = context.getPackageManager().getReceiverInfo(new ComponentName(context, clazz), 2);
            if (activityInfo != null && activityInfo.enabled && (!bl || activityInfo.exported)) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean zza(Context context, Class<? extends Service> clazz) {
        try {
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(new ComponentName(context, clazz), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

