/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.internal.zzs;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AdvertisingIdClient {
    com.google.android.gms.common.zza zzmf;
    zzs zzmg;
    boolean zzmh;
    Object zzmi = new Object();
    zza zzmj;
    private final Context mContext;
    final long zzmk;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L);
    }

    public AdvertisingIdClient(Context context, long timeoutInMillis) {
        zzv.zzr((Object)context);
        this.mContext = context;
        this.zzmh = false;
        this.zzmk = timeoutInMillis;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zzb(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzb(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzv.zzbJ((String)"Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzmh) {
                this.finish();
            }
            this.zzmf = AdvertisingIdClient.zzj(this.mContext);
            this.zzmg = AdvertisingIdClient.zza(this.mContext, this.zzmf);
            this.zzmh = true;
            if (bl) {
                this.zzad();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzad() {
        Object object = this.zzmi;
        synchronized (object) {
            if (this.zzmj != null) {
                this.zzmj.cancel();
                try {
                    this.zzmj.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.zzmk > 0L) {
                this.zzmj = new zza(this, this.zzmk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        zzv.zzbJ((String)"Calling this from your main thread can lead to deadlock");
        Info info = null;
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzmh) {
                Object object = this.zzmi;
                synchronized (object) {
                    if (this.zzmj == null || !this.zzmj.zzae()) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zzb(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzmh) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzv.zzr((Object)this.zzmf);
            zzv.zzr((Object)this.zzmg);
            try {
                info = new Info(this.zzmg.getId(), this.zzmg.zzc(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzad();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzv.zzbJ((String)"Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzmf == null) {
                return;
            }
            try {
                if (this.zzmh) {
                    zzb.zznb().zza(this.mContext, (ServiceConnection)this.zzmf);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            this.zzmh = false;
            this.zzmg = null;
            this.zzmf = null;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    static com.google.android.gms.common.zza zzj(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        PackageManager packageManager;
        try {
            packageManager = context.getPackageManager();
            packageManager.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        try {
            GooglePlayServicesUtil.zzM((Context)context);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new IOException(googlePlayServicesNotAvailableException);
        }
        packageManager = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (zzb.zznb().zza(context, intent, (ServiceConnection)packageManager, 1)) {
            return packageManager;
        }
        throw new IOException("Connection failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L);
        try {
            advertisingIdClient.zzb(false);
            Info info = advertisingIdClient.getInfo();
            return info;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    static zzs zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzs.zza.zzb(zza2.zzku());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
    }

    public static final class Info {
        private final String zzmp;
        private final boolean zzmq;

        public Info(String advertisingId, boolean limitAdTrackingEnabled) {
            this.zzmp = advertisingId;
            this.zzmq = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.zzmp;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzmq;
        }

        public String toString() {
            return "{" + this.zzmp + "}" + this.zzmq;
        }
    }

    static class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzml;
        private long zzmm;
        CountDownLatch zzmn;
        boolean zzmo;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzml = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzmm = l;
            this.zzmn = new CountDownLatch(1);
            this.zzmo = false;
            this.start();
        }

        public void cancel() {
            this.zzmn.countDown();
        }

        public boolean zzae() {
            return this.zzmo;
        }

        private void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzml.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzmo = true;
            }
        }

        @Override
        public void run() {
            try {
                if (!this.zzmn.await(this.zzmm, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
            }
        }
    }
}

